/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SimpleExpressionEvalContext
implements ExpressionEvalContext {
    public static final String SQL_ARGUMENTS_KEY_NAME = "__sql.arguments";
    private final List<Object> arguments;
    private final InternalSerializationService serializationService;

    public SimpleExpressionEvalContext(@Nonnull List<Object> arguments, @Nonnull InternalSerializationService serializationService) {
        this.arguments = Objects.requireNonNull(arguments);
        this.serializationService = Objects.requireNonNull(serializationService);
    }

    public static SimpleExpressionEvalContext from(ProcessorSupplier.Context ctx) {
        return new SimpleExpressionEvalContext((List)Objects.requireNonNull(ctx.jobConfig().getArgument(SQL_ARGUMENTS_KEY_NAME)), ((Contexts.ProcSupplierCtx)ctx).serializationService());
    }

    @Override
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }
}

