/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.Optionality;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastAggFunction;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;

public class HazelcastAvgAggFunction
extends HazelcastAggFunction {
    public HazelcastAvgAggFunction() {
        super("AVG", SqlKind.AVG, ReturnTypes.AVG_AGG_FUNCTION, new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT), null, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        RelDataType operandType = binding.getOperandType(0);
        if (!HazelcastTypeUtils.isNumericType(operandType)) {
            if (throwOnFailure) {
                throw binding.newValidationSignatureError();
            }
            return false;
        }
        RelDataType resultType = HazelcastTypeUtils.isNumericIntegerType(operandType) || operandType.getSqlTypeName() == SqlTypeName.DECIMAL ? HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.DECIMAL) : HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.DOUBLE);
        TypedOperandChecker checker = TypedOperandChecker.forType(resultType);
        assert (checker.isNumeric());
        return checker.check(binding, throwOnFailure, 0);
    }
}

