/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Optionality;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastAggFunction;
import com.hazelcast.sql.impl.calcite.validate.param.NoOpParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;

public class HazelcastCountAggFunction
extends HazelcastAggFunction {
    public HazelcastCountAggFunction() {
        super("COUNT", SqlKind.COUNT, (SqlOperatorBinding opBinding) -> HazelcastIntegerType.create(64, false), new IgnoreCountStarOperandTypeInference(new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT)), null, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_STAR;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return HazelcastIntegerType.create(64, false);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        SqlNode node = binding.operand(0);
        if (node.getKind() == SqlKind.DYNAMIC_PARAM) {
            int parameterIndex = ((SqlDynamicParam)node).getIndex();
            binding.getValidator().setParameterConverter(parameterIndex, NoOpParameterConverter.INSTANCE);
        }
        return true;
    }

    private static class IgnoreCountStarOperandTypeInference
    implements SqlOperandTypeInference {
        private final SqlOperandTypeInference delegate;

        IgnoreCountStarOperandTypeInference(SqlOperandTypeInference delegate) {
            this.delegate = delegate;
        }

        @Override
        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            if (callBinding.getCall().isCountStar()) {
                return;
            }
            this.delegate.inferOperandTypes(callBinding, returnType, operandTypes);
        }
    }
}

