/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SqlConnector {
    public static final String OPTION_FORMAT = "format";
    public static final String OPTION_KEY_FORMAT = "keyFormat";
    public static final String OPTION_VALUE_FORMAT = "valueFormat";
    public static final String OPTION_KEY_CLASS = "keyJavaClass";
    public static final String OPTION_VALUE_CLASS = "valueJavaClass";
    public static final String OPTION_KEY_FACTORY_ID = "keyPortableFactoryId";
    public static final String OPTION_KEY_CLASS_ID = "keyPortableClassId";
    public static final String OPTION_KEY_CLASS_VERSION = "keyPortableClassVersion";
    public static final String OPTION_VALUE_FACTORY_ID = "valuePortableFactoryId";
    public static final String OPTION_VALUE_CLASS_ID = "valuePortableClassId";
    public static final String OPTION_VALUE_CLASS_VERSION = "valuePortableClassVersion";
    public static final String JAVA_FORMAT = "java";
    public static final String PORTABLE_FORMAT = "portable";
    public static final String JSON_FORMAT = "json";
    public static final String CSV_FORMAT = "csv";
    public static final String AVRO_FORMAT = "avro";
    public static final String PARQUET_FORMAT = "parquet";

    public String typeName();

    public boolean isStream();

    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine var1, @Nonnull Map<String, String> var2, @Nonnull List<MappingField> var3);

    @Nonnull
    public Table createTable(@Nonnull NodeEngine var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, @Nonnull Map<String, String> var5, @Nonnull List<MappingField> var6);

    @Nonnull
    default public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projection) {
        throw new UnsupportedOperationException("Full scan not supported for " + this.typeName());
    }

    @Nonnull
    default public VertexWithInputConfig nestedLoopReader(@Nonnull DAG dag, @Nonnull Table table, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projection, @Nonnull JetJoinInfo joinInfo) {
        throw new UnsupportedOperationException("Nested-loop join not supported for " + this.typeName());
    }

    @Nonnull
    default public VertexWithInputConfig insertProcessor(@Nonnull DAG dag, @Nonnull Table table) {
        throw new UnsupportedOperationException("INSERT INTO not supported for " + this.typeName());
    }

    @Nonnull
    default public Vertex sinkProcessor(@Nonnull DAG dag, @Nonnull Table table) {
        throw new UnsupportedOperationException("SINK INTO not supported for " + this.typeName());
    }

    @Nonnull
    default public Vertex updateProcessor(@Nonnull DAG dag, @Nonnull Table table, @Nonnull Map<String, Expression<?>> updatesByFieldNames) {
        throw new UnsupportedOperationException("UPDATE not supported for " + this.typeName());
    }

    @Nonnull
    default public Vertex deleteProcessor(@Nonnull DAG dag, @Nonnull Table table) {
        throw new UnsupportedOperationException("DELETE not supported for " + this.typeName());
    }

    @Nonnull
    default public List<String> getPrimaryKey(Table table) {
        throw new UnsupportedOperationException("PRIMARY KEY not supported by connector: " + this.typeName());
    }

    public static class VertexWithInputConfig {
        private final Vertex vertex;
        private final Consumer<Edge> configureEdgeFn;

        public VertexWithInputConfig(Vertex vertex) {
            this(vertex, null);
        }

        public VertexWithInputConfig(Vertex vertex, Consumer<Edge> configureEdgeFn) {
            this.vertex = vertex;
            this.configureEdgeFn = configureEdgeFn;
        }

        public Vertex vertex() {
            return this.vertex;
        }

        public Consumer<Edge> configureEdgeFn() {
            return this.configureEdgeFn;
        }
    }
}

