/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlProcessors;
import com.hazelcast.jet.sql.impl.connector.file.AvroMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.CsvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.FileTable;
import com.hazelcast.jet.sql.impl.connector.file.JsonMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.file.ParquetMetadataResolver;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "File";
    public static final String OPTION_PATH = "path";
    public static final String OPTION_GLOB = "glob";
    public static final String OPTION_SHARED_FILE_SYSTEM = "sharedFileSystem";
    public static final String OPTION_IGNORE_FILE_NOT_FOUND = "ignoreFileNotFound";
    public static final String OPTION_OPTIONS = "options";
    static final FileSqlConnector INSTANCE = new FileSqlConnector();
    private static final MetadataResolvers METADATA_RESOLVERS = new MetadataResolvers(CsvMetadataResolver.INSTANCE, JsonMetadataResolver.INSTANCE, AvroMetadataResolver.INSTANCE, ParquetMetadataResolver.INSTANCE);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields) {
        return FileSqlConnector.resolveAndValidateFields(options, userFields);
    }

    @Nonnull
    static List<MappingField> resolveAndValidateFields(@Nonnull Map<String, ?> options, @Nonnull List<MappingField> userFields) {
        return METADATA_RESOLVERS.resolveAndValidateFields(userFields, options);
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        Metadata metadata = METADATA_RESOLVERS.resolveMetadata(resolvedFields, options);
        return new FileTable.SpecificFileTable(INSTANCE, schemaName, mappingName, metadata.fields(), metadata.processorMetaSupplier(), metadata.queryTargetSupplier());
    }

    @Nonnull
    static Table createTable(@Nonnull String schemaName, @Nonnull String name, @Nonnull Map<String, ?> options, @Nonnull List<MappingField> resolvedFields) {
        Metadata metadata = METADATA_RESOLVERS.resolveMetadata(resolvedFields, options);
        return new FileTable.DynamicFileTable(INSTANCE, schemaName, name, metadata.fields(), metadata.processorMetaSupplier(), metadata.queryTargetSupplier());
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections) {
        FileTable table = (FileTable)table0;
        Vertex vStart = dag.newUniqueVertex(table.toString(), table.processorMetaSupplier());
        Vertex vEnd = dag.newUniqueVertex("Project(" + table + ")", SqlProcessors.rowProjector(table.paths(), table.types(), table.queryTargetSupplier(), predicate, projections));
        dag.edge(Edge.between(vStart, vEnd).isolated());
        return vEnd;
    }
}

