/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.file.FileTableField;
import com.hazelcast.jet.sql.impl.connector.file.ProcessorMetaSupplierProvider;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.Objects;

abstract class FileTable
extends JetTable {
    protected final ProcessorMetaSupplierProvider processorMetaSupplierProvider;
    private final SupplierEx<QueryTarget> queryTargetSupplier;

    protected FileTable(SqlConnector sqlConnector, String schemaName, String name, List<TableField> fields, ProcessorMetaSupplierProvider processorMetaSupplierProvider, SupplierEx<QueryTarget> queryTargetSupplier) {
        super(sqlConnector, fields, schemaName, name, new ConstantTableStatistics(0L));
        this.processorMetaSupplierProvider = processorMetaSupplierProvider;
        this.queryTargetSupplier = queryTargetSupplier;
    }

    ProcessorMetaSupplier processorMetaSupplier() {
        return this.processorMetaSupplierProvider.get();
    }

    SupplierEx<QueryTarget> queryTargetSupplier() {
        return this.queryTargetSupplier;
    }

    String[] paths() {
        return (String[])this.getFields().stream().map(field -> ((FileTableField)field).getPath()).toArray(String[]::new);
    }

    QueryDataType[] types() {
        return (QueryDataType[])this.getFields().stream().map(TableField::getType).toArray(QueryDataType[]::new);
    }

    static final class FilePlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String name;
        private final List<TableField> fields;
        private final ProcessorMetaSupplierProvider processorMetaSupplierProvider;

        FilePlanObjectKey(String schemaName, String name, List<TableField> fields, ProcessorMetaSupplierProvider processorMetaSupplierProvider) {
            this.schemaName = schemaName;
            this.name = name;
            this.fields = fields;
            this.processorMetaSupplierProvider = processorMetaSupplierProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilePlanObjectKey that = (FilePlanObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.name, that.name) && Objects.equals(this.fields, that.fields) && Objects.equals(this.processorMetaSupplierProvider, that.processorMetaSupplierProvider);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.name, this.fields, this.processorMetaSupplierProvider);
        }
    }

    static class DynamicFileTable
    extends FileTable {
        DynamicFileTable(SqlConnector sqlConnector, String schemaName, String name, List<TableField> fields, ProcessorMetaSupplierProvider processorMetaSupplierProvider, SupplierEx<QueryTarget> queryTargetSupplier) {
            super(sqlConnector, schemaName, name, fields, processorMetaSupplierProvider, queryTargetSupplier);
        }

        @Override
        public PlanObjectKey getObjectKey() {
            return PlanObjectKey.NON_CACHEABLE_OBJECT_KEY;
        }
    }

    static class SpecificFileTable
    extends FileTable {
        SpecificFileTable(SqlConnector sqlConnector, String schemaName, String name, List<TableField> fields, ProcessorMetaSupplierProvider processorMetaSupplierProvider, SupplierEx<QueryTarget> queryTargetSupplier) {
            super(sqlConnector, schemaName, name, fields, processorMetaSupplierProvider, queryTargetSupplier);
        }

        @Override
        public PlanObjectKey getObjectKey() {
            return new FilePlanObjectKey(this.getSchemaName(), this.getSqlName(), this.getFields(), this.processorMetaSupplierProvider);
        }
    }
}

