/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.file.FileSqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetDynamicTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.operators.HazelcastOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FileTableFunction
extends JetDynamicTableFunction {
    private static final String SCHEMA_NAME_FILES = "files";
    private static final List<JetTableFunctionParameter> PARAMETERS = Arrays.asList(new JetTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, TypedOperandChecker.VARCHAR), new JetTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, TypedOperandChecker.VARCHAR), new JetTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, TypedOperandChecker.VARCHAR), new JetTableFunctionParameter(3, "options", SqlTypeName.MAP, TypedOperandChecker.MAP));

    public FileTableFunction(String name, String format) {
        super(name, PARAMETERS, (List<Object> arguments) -> FileTableFunction.toTable(arguments, format), (SqlOperandTypeInference)new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY)), (SqlConnector)FileSqlConnector.INSTANCE);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(1, PARAMETERS.size());
    }

    private static Table toTable(List<Object> arguments, String format) {
        Map<String, Object> options = FileTableFunction.toOptions(arguments, format);
        List<MappingField> fields = FileSqlConnector.resolveAndValidateFields(options, Collections.emptyList());
        return FileSqlConnector.createTable(SCHEMA_NAME_FILES, FileTableFunction.randomName(), options, fields);
    }

    private static Map<String, Object> toOptions(List<Object> arguments, String format) {
        assert (arguments.size() == PARAMETERS.size());
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("format", format);
        for (int i = 0; i < arguments.size(); ++i) {
            if (arguments.get(i) == null) continue;
            options.put(PARAMETERS.get(i).name(), arguments.get(i));
        }
        return options;
    }

    private static String randomName() {
        return "files_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

