/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesTable;
import com.hazelcast.jet.sql.impl.schema.JetSpecificTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.operators.HazelcastOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SeriesGeneratorTableFunction
extends JetSpecificTableFunction {
    private static final String SCHEMA_NAME_SERIES = "series";
    private static final String FUNCTION_NAME = "GENERATE_SERIES";
    private static final List<JetTableFunctionParameter> PARAMETERS = Arrays.asList(new JetTableFunctionParameter(0, "start", SqlTypeName.INTEGER, TypedOperandChecker.INTEGER), new JetTableFunctionParameter(1, "stop", SqlTypeName.INTEGER, TypedOperandChecker.INTEGER), new JetTableFunctionParameter(2, "step", SqlTypeName.INTEGER, TypedOperandChecker.INTEGER));

    public SeriesGeneratorTableFunction() {
        super(FUNCTION_NAME, PARAMETERS, (SqlOperatorBinding binding) -> SeriesGeneratorTableFunction.toTable0(Collections.emptyList()).getRowType(binding.getTypeFactory()), (SqlOperandTypeInference)new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.INTEGER)), SeriesSqlConnector.INSTANCE);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public HazelcastTable toTable(List<Expression<?>> argumentExpressions) {
        return SeriesGeneratorTableFunction.toTable0(argumentExpressions);
    }

    private static HazelcastTable toTable0(List<Expression<?>> argumentExpressions) {
        SeriesTable table = SeriesSqlConnector.createTable(SCHEMA_NAME_SERIES, SeriesGeneratorTableFunction.randomName(), argumentExpressions);
        return new HazelcastTable(table, new HazelcastTableStatistic(0L));
    }

    private static String randomName() {
        return "series_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

