/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

class SeriesTable
extends JetTable {
    private final List<Expression<?>> argumentExpressions;

    SeriesTable(SqlConnector sqlConnector, List<TableField> fields, String schemaName, String name, List<Expression<?>> argumentExpressions) {
        super(sqlConnector, fields, schemaName, name, new ConstantTableStatistics(0L));
        this.argumentExpressions = argumentExpressions;
    }

    BatchSource<Object[]> items(Expression<Boolean> predicate, List<Expression<?>> projections) {
        List<Expression<?>> argumentExpressions = this.argumentExpressions;
        return ((SourceBuilder.Batch)SourceBuilder.batch("series", ctx -> {
            SimpleExpressionEvalContext evalContext = SimpleExpressionEvalContext.from(ctx);
            Integer start = SeriesTable.evaluate((Expression)argumentExpressions.get(0), null, evalContext);
            Integer stop = SeriesTable.evaluate((Expression)argumentExpressions.get(1), null, evalContext);
            Integer step = SeriesTable.evaluate((Expression)argumentExpressions.get(2), 1, evalContext);
            if (start == null || stop == null || step == null) {
                throw QueryException.error("Invalid argument of a call to function GENERATE_SERIES - null argument(s)");
            }
            if (step == 0) {
                throw QueryException.error("Invalid argument of a call to function GENERATE_SERIES - step cannot be equal to zero");
            }
            return new DataGenerator(start, stop, step, predicate, projections, evalContext);
        }).fillBufferFn((rec$, x$0) -> ((DataGenerator)rec$).fillBuffer(x$0))).build();
    }

    private static Integer evaluate(Expression<?> argumentExpression, Integer defaultValue, ExpressionEvalContext evalContext) {
        if (argumentExpression == null) {
            return defaultValue;
        }
        Integer value = (Integer)argumentExpression.eval(EmptyRow.INSTANCE, evalContext);
        return value == null ? defaultValue : value;
    }

    @Override
    public PlanObjectKey getObjectKey() {
        return null;
    }

    private static final class DataGenerator {
        private static final int MAX_BATCH_SIZE = 1024;
        private final Iterator<Object[]> iterator;

        private DataGenerator(int start, int stop, int step, Expression<Boolean> predicate, List<Expression<?>> projections, ExpressionEvalContext evalContext) {
            this.iterator = IntStream.iterate(start, i -> i + step).limit(DataGenerator.numberOfItems(start, stop, step)).mapToObj(i -> ExpressionUtil.evaluate(predicate, projections, new Object[]{i}, evalContext)).filter(Objects::nonNull).iterator();
        }

        private void fillBuffer(SourceBuilder.SourceBuffer<Object[]> buffer) {
            for (int i = 0; i < 1024; ++i) {
                if (this.iterator.hasNext()) {
                    buffer.add(this.iterator.next());
                    continue;
                }
                buffer.close();
            }
        }

        private static long numberOfItems(int start, int stop, int step) {
            if (start <= stop) {
                return step < 0 ? 0L : ((long)stop - (long)start) / (long)step + 1L;
            }
            return step > 0 ? 0L : ((long)start - (long)stop) / (long)(-step) + 1L;
        }
    }
}

