/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.StreamSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.StreamTable;
import com.hazelcast.jet.sql.impl.schema.JetSpecificTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.operators.HazelcastOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.Collections;
import java.util.List;

public final class StreamGeneratorTableFunction
extends JetSpecificTableFunction {
    private static final String SCHEMA_NAME_STREAM = "stream";
    private static final String FUNCTION_NAME = "GENERATE_STREAM";
    private static final List<JetTableFunctionParameter> PARAMETERS = Collections.singletonList(new JetTableFunctionParameter(0, "rate", SqlTypeName.INTEGER, TypedOperandChecker.INTEGER));

    public StreamGeneratorTableFunction() {
        super(FUNCTION_NAME, PARAMETERS, (SqlOperatorBinding binding) -> StreamGeneratorTableFunction.toTable0(Collections.emptyList()).getRowType(binding.getTypeFactory()), (SqlOperandTypeInference)new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.INTEGER)), StreamSqlConnector.INSTANCE);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public HazelcastTable toTable(List<Expression<?>> argumentExpressions) {
        return StreamGeneratorTableFunction.toTable0(argumentExpressions);
    }

    private static HazelcastTable toTable0(List<Expression<?>> argumentExpressions) {
        StreamTable table = StreamSqlConnector.createTable(SCHEMA_NAME_STREAM, StreamGeneratorTableFunction.randomName(), argumentExpressions);
        return new HazelcastTable(table, new HazelcastTableStatistic(Integer.MAX_VALUE));
    }

    private static String randomName() {
        return "stream_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

