/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kafka.impl.StreamKafkaP;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class RowProjectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private Properties properties;
    private String topic;
    private EventTimePolicy<Object[]> eventTimePolicy;
    private KvRowProjector.Supplier projectorSupplier;
    private transient ExpressionEvalContext evalContext;
    private transient Extractors extractors;

    private RowProjectorProcessorSupplier() {
    }

    RowProjectorProcessorSupplier(Properties properties, String topic, EventTimePolicy<Object[]> eventTimePolicy, QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projection) {
        this.properties = properties;
        this.topic = topic;
        this.eventTimePolicy = eventTimePolicy;
        this.projectorSupplier = KvRowProjector.supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projection);
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.evalContext = SimpleExpressionEvalContext.from(context);
        this.extractors = Extractors.newBuilder(this.evalContext.getSerializationService()).build();
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<StreamKafkaP> processors = new ArrayList<StreamKafkaP>(count);
        for (int i = 0; i < count; ++i) {
            KvRowProjector projector = this.projectorSupplier.get(this.evalContext, this.extractors);
            StreamKafkaP processor = new StreamKafkaP(this.properties, Collections.singletonList(this.topic), record -> projector.project(record.key(), record.value()), this.eventTimePolicy);
            processors.add(processor);
        }
        return processors;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.properties);
        out.writeString(this.topic);
        out.writeObject(this.projectorSupplier);
        out.writeObject(this.eventTimePolicy);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.properties = (Properties)in.readObject();
        this.topic = in.readString();
        this.projectorSupplier = (KvRowProjector.Supplier)in.readObject();
        this.eventTimePolicy = (EventTimePolicy)in.readObject();
    }
}

