/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.connector.keyvalue.JavaClassNameResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.sql.impl.FieldsUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;

public final class KvMetadataJavaResolver
implements KvMetadataResolver {
    public static final KvMetadataJavaResolver INSTANCE = new KvMetadataJavaResolver();

    @Override
    public Stream<String> supportedFormats() {
        return Stream.concat(Stream.of("java"), JavaClassNameResolver.formats());
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Class<?> clazz = this.loadClass(isKey, options);
        return this.resolveFields(isKey, userFields, clazz);
    }

    public Stream<MappingField> resolveFields(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(clazz);
        if (type != QueryDataType.OBJECT) {
            return this.resolvePrimitiveSchema(isKey, userFields, type);
        }
        return this.resolveObjectSchema(isKey, userFields, clazz);
    }

    private Stream<MappingField> resolvePrimitiveSchema(boolean isKey, List<MappingField> userFields, QueryDataType type) {
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
        String externalName = path.toString();
        MappingField userField = userFieldsByPath.get(path);
        if (userField != null && !userField.name().equals(name)) {
            throw QueryException.error("Cannot rename field: '" + name + '\'');
        }
        if (userField != null && !type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) {
            throw QueryException.error("Mismatch between declared and resolved type for field '" + userField.name() + "'");
        }
        for (MappingField field : userFieldsByPath.values()) {
            if (externalName.equals(field.externalName())) continue;
            throw QueryException.error("The field '" + externalName + "' is of type " + (Object)((Object)type.getTypeFamily()) + ", you can't map '" + field.externalName() + "' too");
        }
        return Stream.of(new MappingField(name, type, externalName));
    }

    private Stream<MappingField> resolveObjectSchema(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        Set<Map.Entry<String, Class<?>>> fieldsInClass = FieldsUtil.resolveClass(clazz).entrySet();
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        if (!userFields.isEmpty()) {
            for (Map.Entry<String, Class<?>> classField2 : fieldsInClass) {
                QueryPath path = new QueryPath(classField2.getKey(), isKey);
                QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(classField2.getValue());
                MappingField userField = userFieldsByPath.get(path);
                if (userField == null || type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) continue;
                throw QueryException.error("Mismatch between declared and resolved type for field '" + userField.name() + "'. Declared: " + (Object)((Object)userField.type().getTypeFamily()) + ", resolved: " + (Object)((Object)type.getTypeFamily()));
            }
            return userFieldsByPath.values().stream();
        }
        if (fieldsInClass.isEmpty()) {
            String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
            return Stream.of(new MappingField(name, QueryDataType.OBJECT, name));
        }
        return fieldsInClass.stream().map(classField -> {
            QueryPath path = new QueryPath((String)classField.getKey(), isKey);
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)classField.getValue());
            String name = (String)classField.getKey();
            return new MappingField(name, type, path.toString());
        });
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Class<?> clazz = this.loadClass(isKey, options);
        return this.resolveMetadata(isKey, resolvedFields, clazz);
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Class<?> clazz) {
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(clazz);
        Map<QueryPath, MappingField> fields = KvMetadataResolver.extractFields(resolvedFields, isKey);
        if (type != QueryDataType.OBJECT) {
            return this.resolvePrimitiveMetadata(isKey, fields);
        }
        return this.resolveObjectMetadata(isKey, resolvedFields, fields, clazz);
    }

    private KvMetadata resolvePrimitiveMetadata(boolean isKey, Map<QueryPath, MappingField> fieldsByPath) {
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        MappingField field = fieldsByPath.get(path);
        return new KvMetadata(field != null ? Collections.singletonList(new MapTableField(field.name(), field.type(), false, path)) : Collections.emptyList(), GenericQueryTargetDescriptor.DEFAULT, PrimitiveUpsertTargetDescriptor.INSTANCE);
    }

    private KvMetadata resolveObjectMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, Class<?> clazz) {
        SortedMap<String, Class<?>> typesByNames = FieldsUtil.resolveClass(clazz);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        HashMap<String, String> typeNamesByPaths = new HashMap<String, String>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
            if (path.getPath() == null || typesByNames.get(path.getPath()) == null) continue;
            typeNamesByPaths.put(path.getPath(), ((Class)typesByNames.get(path.getPath())).getName());
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields);
        return new KvMetadata(fields, GenericQueryTargetDescriptor.DEFAULT, new PojoUpsertTargetDescriptor(clazz.getName(), typeNamesByPaths));
    }

    private Class<?> loadClass(boolean isKey, Map<String, String> options) {
        String className;
        String formatProperty = options.get(isKey ? "keyFormat" : "valueFormat");
        String classNameProperty = isKey ? "keyJavaClass" : "valueJavaClass";
        String string = className = "java".equals(formatProperty) ? options.get(classNameProperty) : JavaClassNameResolver.resolveClassName(formatProperty);
        if (className == null) {
            throw QueryException.error("Unable to resolve table metadata. Missing '" + classNameProperty + "' option");
        }
        try {
            return ReflectionUtils.loadClass(className);
        }
        catch (Exception e) {
            throw QueryException.error("Unable to load class: '" + className + "'", e);
        }
    }
}

