/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface KvMetadataResolver {
    public Stream<String> supportedFormats();

    public Stream<MappingField> resolveAndValidateFields(boolean var1, List<MappingField> var2, Map<String, String> var3, InternalSerializationService var4);

    public KvMetadata resolveMetadata(boolean var1, List<MappingField> var2, Map<String, String> var3, InternalSerializationService var4);

    public static Map<QueryPath, MappingField> extractFields(List<MappingField> fields, boolean isKey) {
        LinkedHashMap<QueryPath, MappingField> fieldsByPath = new LinkedHashMap<QueryPath, MappingField>();
        for (MappingField field : fields) {
            QueryPath path = QueryPath.create(field.externalName());
            if (isKey != path.isKey() || fieldsByPath.putIfAbsent(path, field) == null) continue;
            throw QueryException.error("Duplicate external name: " + path);
        }
        return fieldsByPath;
    }

    public static void maybeAddDefaultField(boolean isKey, @Nonnull List<MappingField> resolvedFields, @Nonnull List<TableField> tableFields) {
        String fieldName;
        String string = fieldName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        if (resolvedFields.stream().noneMatch(field -> field.name().equals(fieldName))) {
            tableFields.add(new MapTableField(fieldName, QueryDataType.OBJECT, true, QueryPath.create(fieldName)));
        }
    }
}

