/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KvMetadataResolvers {
    private static final Pattern EXT_NAME_PATTERN = Pattern.compile("((" + QueryPath.KEY + "|" + QueryPath.VALUE + ")\\.)?[^.]+");
    private final Map<String, KvMetadataResolver> keyResolvers;
    private final Map<String, KvMetadataResolver> valueResolvers;

    public KvMetadataResolvers(KvMetadataResolver ... resolvers) {
        this(resolvers, resolvers);
    }

    public KvMetadataResolvers(KvMetadataResolver[] keyResolvers, KvMetadataResolver[] valueResolvers) {
        this.keyResolvers = this.resolversMap(keyResolvers);
        this.valueResolvers = this.resolversMap(valueResolvers);
    }

    private Map<String, KvMetadataResolver> resolversMap(KvMetadataResolver[] resolvers) {
        return Arrays.stream(resolvers).flatMap(resolver -> resolver.supportedFormats().map(format -> Util.entry(format, resolver))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, String> options, NodeEngine nodeEngine) {
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        for (MappingField field2 : userFields) {
            String name = field2.name();
            String externalName = field2.externalName();
            if (externalName == null) {
                externalName = name.equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) ? name : QueryPath.VALUE_PREFIX + name;
                field2.setExternalName(name);
            }
            if (name.equals(QueryPath.KEY) && !externalName.equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) && !externalName.equals(QueryPath.VALUE)) {
                throw QueryException.error("Cannot rename field: '" + name + '\'');
            }
            if (EXT_NAME_PATTERN.matcher(externalName).matches()) continue;
            throw QueryException.error("Invalid external name: " + externalName);
        }
        List keyFields = this.findMetadataResolver(options, true).resolveAndValidateFields(true, userFields, options, ss).filter(field -> !field.name().equals(QueryPath.KEY) || field.externalName().equals(QueryPath.KEY)).collect(Collectors.toList());
        List valueFields = this.findMetadataResolver(options, false).resolveAndValidateFields(false, userFields, options, ss).filter(field -> !field.name().equals(QueryPath.VALUE) || field.externalName().equals(QueryPath.VALUE)).collect(Collectors.toList());
        Map fields = Stream.concat(keyFields.stream(), valueFields.stream()).collect(LinkedHashMap::new, (map, field) -> map.putIfAbsent(field.name(), field), Map::putAll);
        if (fields.isEmpty()) {
            throw QueryException.error("The resolved field list is empty");
        }
        return new ArrayList<MappingField>(fields.values());
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        KvMetadataResolver resolver = this.findMetadataResolver(options, isKey);
        return Objects.requireNonNull(resolver.resolveMetadata(isKey, resolvedFields, options, serializationService));
    }

    private KvMetadataResolver findMetadataResolver(Map<String, String> options, boolean isKey) {
        String option;
        String format;
        KvMetadataResolver resolver = (isKey ? this.keyResolvers : this.valueResolvers).get(format = options.get(option = isKey ? "keyFormat" : "valueFormat"));
        if (resolver == null) {
            if (format == null) {
                throw QueryException.error("Missing '" + option + "' option");
            }
            throw QueryException.error("Unsupported serialization format: " + format);
        }
        return resolver;
    }
}

