/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.JoinByEquiJoinProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.JoinByPrimitiveKeyProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.JoinScanProcessorSupplier;
import com.hazelcast.sql.impl.extract.QueryPath;

final class IMapJoiner {
    private IMapJoiner() {
    }

    static SqlConnector.VertexWithInputConfig join(DAG dag, String mapName, String tableName, JetJoinInfo joinInfo, KvRowProjector.Supplier rightRowProjectorSupplier) {
        int leftEquiJoinPrimitiveKeyIndex = IMapJoiner.leftEquiJoinPrimitiveKeyIndex(joinInfo, rightRowProjectorSupplier.paths());
        if (leftEquiJoinPrimitiveKeyIndex > -1) {
            return new SqlConnector.VertexWithInputConfig(dag.newUniqueVertex("Join(Lookup-" + tableName + ")", new JoinByPrimitiveKeyProcessorSupplier(joinInfo.isInner(), leftEquiJoinPrimitiveKeyIndex, joinInfo.condition(), mapName, rightRowProjectorSupplier)), edge -> edge.distributed().partitioned(IMapJoiner.extractPrimitiveKeyFn(leftEquiJoinPrimitiveKeyIndex)));
        }
        if (joinInfo.isEquiJoin()) {
            assert (joinInfo.isLeftOuter() || joinInfo.isInner());
            return new SqlConnector.VertexWithInputConfig(dag.newUniqueVertex("Join(Predicate-" + tableName + ")", JoinByEquiJoinProcessorSupplier.supplier(joinInfo, mapName, rightRowProjectorSupplier)), edge -> {
                if (joinInfo.isInner()) {
                    edge.distributed().fanout();
                }
            });
        }
        return new SqlConnector.VertexWithInputConfig(dag.newUniqueVertex("Join(Scan-" + tableName + ")", new JoinScanProcessorSupplier(joinInfo, mapName, rightRowProjectorSupplier)));
    }

    private static int leftEquiJoinPrimitiveKeyIndex(JetJoinInfo joinInfo, QueryPath[] rightPaths) {
        int[] rightEquiJoinIndices = joinInfo.rightEquiJoinIndices();
        for (int i = 0; i < rightEquiJoinIndices.length; ++i) {
            QueryPath path = rightPaths[rightEquiJoinIndices[i]];
            if (!path.isTop() || !path.isKey()) continue;
            return joinInfo.leftEquiJoinIndices()[i];
        }
        return -1;
    }

    private static FunctionEx<Object, ?> extractPrimitiveKeyFn(int index) {
        return row -> {
            Object value = ((Object[])row)[index];
            return value == null ? "" : value;
        };
    }
}

