/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProcessors;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.IMapJoiner;
import com.hazelcast.jet.sql.impl.connector.map.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.MetadataJsonResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.connector.map.RowProjectorProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.UpdateProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.ValueProjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IMapSqlConnector
implements SqlConnector {
    public static final IMapSqlConnector INSTANCE = new IMapSqlConnector();
    public static final String TYPE_NAME = "IMap";
    public static final List<String> PRIMARY_KEY_LIST = Collections.singletonList(QueryPath.KEY);
    private static final KvMetadataResolvers METADATA_RESOLVERS = new KvMetadataResolvers(KvMetadataJavaResolver.INSTANCE, MetadataPortableResolver.INSTANCE, MetadataJsonResolver.INSTANCE);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields) {
        return METADATA_RESOLVERS.resolveAndValidateFields(userFields, options, nodeEngine);
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        KvMetadata keyMetadata = METADATA_RESOLVERS.resolveMetadata(true, resolvedFields, options, ss);
        KvMetadata valueMetadata = METADATA_RESOLVERS.resolveMetadata(false, resolvedFields, options, ss);
        List<TableField> fields = Stream.concat(keyMetadata.getFields().stream(), valueMetadata.getFields().stream()).collect(Collectors.toList());
        MapService service = (MapService)nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        MapContainer container = context.getMapContainer(externalName);
        long estimatedRowCount = MapTableUtils.estimatePartitionedMapRowCount(nodeEngine, context, externalName);
        boolean hd = container != null && container.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
        return new PartitionedMapTable(schemaName, mappingName, externalName, fields, new ConstantTableStatistics(estimatedRowCount), keyMetadata.getQueryTargetDescriptor(), valueMetadata.getQueryTargetDescriptor(), keyMetadata.getUpsertTargetDescriptor(), valueMetadata.getUpsertTargetDescriptor(), Collections.emptyList(), hd);
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> filter, @Nonnull List<Expression<?>> projection) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        Vertex vStart = dag.newUniqueVertex(IMapSqlConnector.toString(table), SourceProcessors.readMapP(table.getMapName()));
        Vertex vEnd = dag.newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", RowProjectorProcessorSupplier.rowProjector(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), filter, projection));
        dag.edge(Edge.from(vStart).to(vEnd).isolated());
        return vEnd;
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig nestedLoopReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nonnull JetJoinInfo joinInfo) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        KvRowProjector.Supplier rightRowProjectorSupplier = KvRowProjector.supplier(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), predicate, projections);
        return IMapJoiner.join(dag, table.getMapName(), IMapSqlConnector.toString(table), joinInfo, rightRowProjectorSupplier);
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        Vertex vertex = dag.newUniqueVertex(IMapSqlConnector.toString(table), new InsertProcessorSupplier(table.getMapName(), KvProjector.supplier(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata()))).localParallelism(1);
        return new SqlConnector.VertexWithInputConfig(vertex, edge -> edge.distributed().allToOne(UuidUtil.newUnsecureUuidString()));
    }

    @Override
    @Nonnull
    public Vertex sinkProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        Vertex vStart = dag.newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", KvProcessors.entryProjector(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata()));
        Vertex vEnd = dag.newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.writeMapP(table.getMapName()));
        dag.edge(Edge.between(vStart, vEnd));
        return vStart;
    }

    @Override
    @Nonnull
    public Vertex updateProcessor(@Nonnull DAG dag, @Nonnull Table table0, @Nonnull Map<String, Expression<?>> updatesByFieldNames) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        table.keyFields().filter(field -> updatesByFieldNames.containsKey(field.getName())).findFirst().ifPresent(field -> {
            throw QueryException.error("Cannot update '" + field.getName() + '\'');
        });
        if (updatesByFieldNames.containsKey(QueryPath.VALUE) && table.valueFields().count() > 1L) {
            throw QueryException.error("Cannot update '" + QueryPath.VALUE + '\'');
        }
        List<Expression<?>> projections = IntStream.range(0, table.getFieldCount()).mapToObj(i -> ColumnExpression.create(i, ((TableField)table.getField(i)).getType())).collect(Collectors.toList());
        KvRowProjector.Supplier rowProjectorSupplier = KvRowProjector.supplier(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), null, projections);
        List<Expression<?>> updates = IntStream.range(0, table.getFieldCount()).filter(i -> !((MapTableField)table.getField(i)).getPath().isKey()).mapToObj(i -> {
            Object field = table.getField(i);
            if (updatesByFieldNames.containsKey(((TableField)field).getName())) {
                return (Expression)updatesByFieldNames.get(((TableField)field).getName());
            }
            if (((TableField)field).getName().equals(QueryPath.VALUE)) {
                return ConstantExpression.create(null, ((TableField)field).getType());
            }
            return ColumnExpression.create(i, ((TableField)field).getType());
        }).collect(Collectors.toList());
        ValueProjector.Supplier valueProjectorSupplier = ValueProjector.supplier(table.valuePaths(), table.valueTypes(), (UpsertTargetDescriptor)table.getValueJetMetadata(), updates);
        return dag.newUniqueVertex("Update(" + IMapSqlConnector.toString(table) + ")", new UpdateProcessorSupplier(table.getMapName(), rowProjectorSupplier, valueProjectorSupplier));
    }

    @Override
    @Nonnull
    public Vertex deleteProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        return dag.newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.updateMapP(table.getMapName(), row -> {
            assert (((Object[])row).length == 1);
            return row[0];
        }, (v, t) -> null));
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table0) {
        return PRIMARY_KEY_LIST;
    }

    private static String toString(PartitionedMapTable table) {
        return "IMap[" + table.getSchemaName() + "." + table.getSqlName() + "]";
    }
}

