/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.AsyncTransformUsingServiceOrderedP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class JoinByPrimitiveKeyProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private static final int MAX_CONCURRENT_OPS = 8;
    private boolean inner;
    private int leftEquiJoinIndex;
    private Expression<Boolean> condition;
    private String mapName;
    private KvRowProjector.Supplier rightRowProjectorSupplier;
    private transient ExpressionEvalContext evalContext;
    private transient Extractors extractors;

    private JoinByPrimitiveKeyProcessorSupplier() {
    }

    JoinByPrimitiveKeyProcessorSupplier(boolean inner, int leftEquiJoinIndex, Expression<Boolean> condition, String mapName, KvRowProjector.Supplier rightRowProjectorSupplier) {
        this.inner = inner;
        this.leftEquiJoinIndex = leftEquiJoinIndex;
        this.condition = condition;
        this.mapName = mapName;
        this.rightRowProjectorSupplier = rightRowProjectorSupplier;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.evalContext = SimpleExpressionEvalContext.from(context);
        this.extractors = Extractors.newBuilder(this.evalContext.getSerializationService()).build();
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList processors = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            String mapName = this.mapName;
            KvRowProjector projector = this.rightRowProjectorSupplier.get(this.evalContext, this.extractors);
            AsyncTransformUsingServiceOrderedP processor = new AsyncTransformUsingServiceOrderedP(ServiceFactories.nonSharedService(SecuredFunctions.iMapFn(mapName)), null, 8, (map, left) -> {
                Object key = left[this.leftEquiJoinIndex];
                if (key == null) {
                    return this.inner ? null : CompletableFuture.completedFuture(null);
                }
                return map.getAsync(key).toCompletableFuture();
            }, (left, value) -> {
                Object[] joined = JoinByPrimitiveKeyProcessorSupplier.join(left, left[this.leftEquiJoinIndex], value, projector, this.condition, this.evalContext);
                return joined != null ? Traversers.singleton(joined) : (this.inner ? null : Traversers.singleton(Util.extendArray(left, projector.getColumnCount())));
            });
            processors.add(processor);
        }
        return processors;
    }

    private static Object[] join(Object[] left, Object key, Object value, KvRowProjector rightRowProjector, Expression<Boolean> condition, ExpressionEvalContext evalContext) {
        if (value == null) {
            return null;
        }
        Object[] right = rightRowProjector.project(key, value);
        if (right == null) {
            return null;
        }
        return ExpressionUtil.join(left, right, condition, evalContext);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.inner);
        out.writeInt(this.leftEquiJoinIndex);
        out.writeObject(this.condition);
        out.writeObject(this.mapName);
        out.writeObject(this.rightRowProjectorSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.inner = in.readBoolean();
        this.leftEquiJoinIndex = in.readInt();
        this.condition = (Expression)in.readObject();
        this.mapName = (String)in.readObject();
        this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }
}

