/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.TransformBatchedP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.QueryUtil;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class JoinScanProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private JetJoinInfo joinInfo;
    private String mapName;
    private KvRowProjector.Supplier rightRowProjectorSupplier;
    private transient IMap<Object, Object> map;
    private transient ExpressionEvalContext evalContext;

    private JoinScanProcessorSupplier() {
    }

    JoinScanProcessorSupplier(JetJoinInfo joinInfo, String mapName, KvRowProjector.Supplier rightRowProjectorSupplier) {
        this.joinInfo = joinInfo;
        this.mapName = mapName;
        this.rightRowProjectorSupplier = rightRowProjectorSupplier;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.map = context.hazelcastInstance().getMap(this.mapName);
        this.evalContext = SimpleExpressionEvalContext.from(context);
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<1> processors = new ArrayList<1>(count);
        for (int i = 0; i < count; ++i) {
            TransformBatchedP<Object[], Object[]> processor = new TransformBatchedP<Object[], Object[]>(JoinScanProcessorSupplier.joinFn(this.joinInfo, this.map, this.rightRowProjectorSupplier, this.evalContext)){

                @Override
                public boolean isCooperative() {
                    return false;
                }
            };
            processors.add(processor);
        }
        return processors;
    }

    private static FunctionEx<Iterable<Object[]>, Traverser<Object[]>> joinFn(@Nonnull JetJoinInfo joinInfo, @Nonnull IMap<Object, Object> map, @Nonnull KvRowProjector.Supplier rightRowProjectorSupplier, @Nonnull ExpressionEvalContext evalContext) {
        Projection<Map.Entry<Object, Object>, Object[]> projection = QueryUtil.toProjection(rightRowProjectorSupplier, evalContext);
        return lefts -> {
            ArrayList<Object[]> rights = new ArrayList<Object[]>();
            for (Object[] right : map.project(projection)) {
                if (right == null) continue;
                rights.add(right);
            }
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            for (Object[] left : lefts) {
                boolean joined = JoinScanProcessorSupplier.join(rows, left, rights, joinInfo.condition(), evalContext);
                if (joined || !joinInfo.isLeftOuter()) continue;
                rows.add(Util.extendArray(left, rightRowProjectorSupplier.columnCount()));
            }
            return Traversers.traverseIterable(rows);
        };
    }

    private static boolean join(@Nonnull List<Object[]> rows, @Nonnull Object[] left, @Nonnull List<Object[]> rights, @Nonnull Expression<Boolean> condition, @Nonnull ExpressionEvalContext evalContext) {
        boolean matched = false;
        for (Object[] right : rights) {
            Object[] joined = ExpressionUtil.join(left, right, condition, evalContext);
            if (joined == null) continue;
            rows.add(joined);
            matched = true;
        }
        return matched;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.joinInfo);
        out.writeObject(this.mapName);
        out.writeObject(this.rightRowProjectorSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.joinInfo = (JetJoinInfo)in.readObject();
        this.mapName = (String)in.readObject();
        this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }
}

