/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.PortableUpsertTargetDescriptor;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

final class MetadataPortableResolver
implements KvMetadataResolver {
    static final MetadataPortableResolver INSTANCE = new MetadataPortableResolver();

    private MetadataPortableResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("portable");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        ClassDefinition classDefinition = MetadataPortableResolver.resolveClassDefinition(isKey, options, userFieldsByPath.values(), serializationService);
        return userFields.isEmpty() ? this.resolveFields(isKey, classDefinition) : MetadataPortableResolver.resolveAndValidateFields(isKey, userFieldsByPath, classDefinition);
    }

    Stream<MappingField> resolveFields(boolean isKey, ClassDefinition clazz) {
        return clazz.getFieldNames().stream().map(name -> {
            QueryPath path = new QueryPath((String)name, isKey);
            QueryDataType type = MetadataPortableResolver.resolvePortableType(clazz.getFieldType((String)name));
            return new MappingField((String)name, type, path.toString());
        });
    }

    private static Stream<MappingField> resolveAndValidateFields(boolean isKey, Map<QueryPath, MappingField> userFieldsByPath, ClassDefinition clazz) {
        for (String name : clazz.getFieldNames()) {
            QueryPath path = new QueryPath(name, isKey);
            QueryDataType type = MetadataPortableResolver.resolvePortableType(clazz.getFieldType(name));
            MappingField userField = userFieldsByPath.get(path);
            if (userField == null || type.getTypeFamily().equals((Object)userField.type().getTypeFamily())) continue;
            throw QueryException.error("Mismatch between declared and resolved type: " + userField.name());
        }
        return userFieldsByPath.values().stream();
    }

    private static QueryDataType resolvePortableType(FieldType type) {
        switch (type) {
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case BYTE: {
                return QueryDataType.TINYINT;
            }
            case SHORT: {
                return QueryDataType.SMALLINT;
            }
            case INT: {
                return QueryDataType.INT;
            }
            case LONG: {
                return QueryDataType.BIGINT;
            }
            case FLOAT: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
            case DECIMAL: {
                return QueryDataType.DECIMAL;
            }
            case CHAR: {
                return QueryDataType.VARCHAR_CHARACTER;
            }
            case UTF: {
                return QueryDataType.VARCHAR;
            }
            case TIME: {
                return QueryDataType.TIME;
            }
            case DATE: {
                return QueryDataType.DATE;
            }
            case TIMESTAMP: {
                return QueryDataType.TIMESTAMP;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
        }
        return QueryDataType.OBJECT;
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        ClassDefinition classDef = MetadataPortableResolver.resolveClassDefinition(isKey, options, fieldsByPath.values(), serializationService);
        return MetadataPortableResolver.resolveMetadata(isKey, resolvedFields, fieldsByPath, classDef);
    }

    KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, @Nonnull ClassDefinition classDef) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        return MetadataPortableResolver.resolveMetadata(isKey, resolvedFields, fieldsByPath, classDef);
    }

    private static KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, @Nonnull ClassDefinition classDef) {
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields);
        return new KvMetadata(fields, GenericQueryTargetDescriptor.DEFAULT, new PortableUpsertTargetDescriptor(classDef));
    }

    @Nonnull
    private static ClassDefinition resolveClassDefinition(boolean isKey, Map<String, String> options, Collection<MappingField> fields, InternalSerializationService serializationService) {
        String factoryIdProperty = isKey ? "keyPortableFactoryId" : "valuePortableFactoryId";
        String factoryIdString = options.get(factoryIdProperty);
        String classIdProperty = isKey ? "keyPortableClassId" : "valuePortableClassId";
        String classIdString = options.get(classIdProperty);
        String classVersionProperty = isKey ? "keyPortableClassVersion" : "valuePortableClassVersion";
        String classVersionString = options.getOrDefault(classVersionProperty, "0");
        if (factoryIdString == null || classIdString == null) {
            throw QueryException.error("Unable to resolve table metadata. Missing ['" + factoryIdProperty + "'|'" + classIdProperty + "'] option(s)");
        }
        int factoryId = MetadataPortableResolver.asInt(factoryIdProperty, factoryIdString);
        int classId = MetadataPortableResolver.asInt(classIdProperty, classIdString);
        int classVersion = MetadataPortableResolver.asInt(classVersionProperty, classVersionString);
        ClassDefinition classDefinition = serializationService.getPortableContext().lookupClassDefinition(factoryId, classId, classVersion);
        if (classDefinition != null) {
            return classDefinition;
        }
        ClassDefinitionBuilder classDefinitionBuilder = new ClassDefinitionBuilder(factoryId, classId, classVersion);
        block15: for (MappingField field : fields) {
            String name = field.name();
            QueryDataType type = field.type();
            switch (type.getTypeFamily()) {
                case BOOLEAN: {
                    classDefinitionBuilder.addBooleanField(name);
                    continue block15;
                }
                case TINYINT: {
                    classDefinitionBuilder.addByteField(name);
                    continue block15;
                }
                case SMALLINT: {
                    classDefinitionBuilder.addShortField(name);
                    continue block15;
                }
                case INTEGER: {
                    classDefinitionBuilder.addIntField(name);
                    continue block15;
                }
                case BIGINT: {
                    classDefinitionBuilder.addLongField(name);
                    continue block15;
                }
                case REAL: {
                    classDefinitionBuilder.addFloatField(name);
                    continue block15;
                }
                case DOUBLE: {
                    classDefinitionBuilder.addDoubleField(name);
                    continue block15;
                }
                case DECIMAL: {
                    classDefinitionBuilder.addDecimalField(name);
                    continue block15;
                }
                case VARCHAR: {
                    classDefinitionBuilder.addStringField(name);
                    continue block15;
                }
                case TIME: {
                    classDefinitionBuilder.addTimeField(name);
                    continue block15;
                }
                case DATE: {
                    classDefinitionBuilder.addDateField(name);
                    continue block15;
                }
                case TIMESTAMP: {
                    classDefinitionBuilder.addTimestampField(name);
                    continue block15;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    classDefinitionBuilder.addTimestampWithTimezoneField(name);
                    continue block15;
                }
            }
            throw QueryException.error("Type " + type + " is not supported for Portable.");
        }
        return classDefinitionBuilder.build();
    }

    private static int asInt(String property, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw QueryException.error("Cannot parse " + property + " value as integer: '" + value + "'");
        }
    }
}

