/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class QueryUtil {
    private QueryUtil() {
    }

    static Predicate<Object, Object> toPredicate(Object[] left, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices, QueryPath[] rightPaths) {
        PredicateBuilder builder = Predicates.newPredicateBuilder();
        PredicateBuilder.EntryObject entryObject = builder.getEntryObject();
        for (int i = 0; i < leftEquiJoinIndices.length; ++i) {
            PredicateBuilder.EntryObject object;
            Comparable<?> leftValue = QueryUtil.asComparable(left[leftEquiJoinIndices[i]]);
            if (leftValue == null) {
                return null;
            }
            QueryPath rightPath = rightPaths[rightEquiJoinIndices[i]];
            if (rightPath.isKey()) {
                object = rightPath.isTop() ? entryObject.key() : entryObject.key().get(rightPath.getPath());
            } else {
                PredicateBuilder.EntryObject entryObject2 = object = rightPath.isTop() ? entryObject.get(rightPath.toString()) : entryObject.get(QueryPath.VALUE).get(rightPath.getPath());
            }
            if (i == 0) {
                object.equal(leftValue);
                continue;
            }
            builder.and(object.equal(leftValue));
        }
        return builder;
    }

    private static Comparable<?> asComparable(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw QueryException.error("JOIN not supported for " + value.getClass() + ": not comparable");
    }

    static Projection<Map.Entry<Object, Object>, Object[]> toProjection(KvRowProjector.Supplier rightRowProjectorSupplier, ExpressionEvalContext evalContext) {
        return new JoinProjection(rightRowProjectorSupplier, evalContext);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class JoinProjection
    implements Projection<Map.Entry<Object, Object>, Object[]>,
    DataSerializable,
    SerializationServiceAware {
        private KvRowProjector.Supplier rightRowProjectorSupplier;
        private List<Object> arguments;
        private transient ExpressionEvalContext evalContext;
        private transient Extractors extractors;

        private JoinProjection() {
        }

        private JoinProjection(KvRowProjector.Supplier rightRowProjectorSupplier, ExpressionEvalContext evalContext) {
            this.rightRowProjectorSupplier = rightRowProjectorSupplier;
            this.evalContext = evalContext;
            this.arguments = evalContext.getArguments();
        }

        @Override
        public Object[] transform(Map.Entry<Object, Object> entry) {
            return this.rightRowProjectorSupplier.get(this.evalContext, this.extractors).project(entry.getKey(), entry.getValue());
        }

        @Override
        public void setSerializationService(SerializationService serializationService) {
            this.evalContext = new SimpleExpressionEvalContext(this.arguments, (InternalSerializationService)serializationService);
            this.extractors = Extractors.newBuilder(this.evalContext.getSerializationService()).build();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.rightRowProjectorSupplier);
            out.writeObject(this.arguments);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
            this.arguments = (List)in.readObject();
        }
    }
}

