/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.impl.processor.TransformP;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public final class RowProjectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private KvRowProjector.Supplier projectorSupplier;
    private transient ExpressionEvalContext evalContext;
    private transient Extractors extractors;

    private RowProjectorProcessorSupplier() {
    }

    public RowProjectorProcessorSupplier(KvRowProjector.Supplier projectorSupplier) {
        this.projectorSupplier = projectorSupplier;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.evalContext = SimpleExpressionEvalContext.from(context);
        this.extractors = Extractors.newBuilder(this.evalContext.getSerializationService()).build();
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList processors = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            ResettableSingletonTraverser traverser = new ResettableSingletonTraverser();
            KvRowProjector projector = this.projectorSupplier.get(this.evalContext, this.extractors);
            TransformP processor = new TransformP(entry -> {
                traverser.accept(projector.project(entry.getKey(), entry.getValue()));
                return traverser;
            });
            processors.add(processor);
        }
        return processors;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.projectorSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.projectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }

    public static ProcessorSupplier rowProjector(QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projection) {
        return new RowProjectorProcessorSupplier(KvRowProjector.supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projection));
    }
}

