/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.com.fasterxml.jackson.core.JsonGenerator;
import com.hazelcast.com.fasterxml.jackson.core.TreeNode;
import com.hazelcast.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class JsonUpsertTarget
implements UpsertTarget {
    private static final JsonFactory JSON_FACTORY = new ObjectMapper().getFactory();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private JsonGenerator generator;

    JsonUpsertTarget() {
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        return value -> {
            try {
                if (value == null) {
                    this.generator.writeNullField(path);
                } else {
                    switch (type.getTypeFamily()) {
                        case BOOLEAN: {
                            this.generator.writeBooleanField(path, (Boolean)value);
                            break;
                        }
                        case TINYINT: {
                            this.generator.writeNumberField(path, ((Byte)value).byteValue());
                            break;
                        }
                        case SMALLINT: {
                            this.generator.writeNumberField(path, (Short)value);
                            break;
                        }
                        case INTEGER: {
                            this.generator.writeNumberField(path, (Integer)value);
                            break;
                        }
                        case BIGINT: {
                            this.generator.writeNumberField(path, (Long)value);
                            break;
                        }
                        case REAL: {
                            this.generator.writeNumberField(path, ((Float)value).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            this.generator.writeNumberField(path, (Double)value);
                            break;
                        }
                        case DECIMAL: 
                        case TIME: 
                        case DATE: 
                        case TIMESTAMP: 
                        case TIMESTAMP_WITH_TIME_ZONE: 
                        case VARCHAR: {
                            this.generator.writeStringField(path, (String)QueryDataType.VARCHAR.convert(value));
                            break;
                        }
                        case OBJECT: {
                            this.injectObject(path, value);
                            break;
                        }
                        default: {
                            throw QueryException.error("Unsupported type: " + type);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        };
    }

    private void injectObject(String path, Object value) throws IOException {
        this.generator.writeFieldName(path);
        if (value == null) {
            this.generator.writeNull();
        } else if (value instanceof TreeNode) {
            this.generator.writeTree((TreeNode)value);
        } else if (value instanceof Map) {
            this.generator.writeObject(value);
        } else if (value instanceof Boolean) {
            this.generator.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.generator.writeNumber(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.generator.writeNumber((Short)value);
        } else if (value instanceof Integer) {
            this.generator.writeNumber((Integer)value);
        } else if (value instanceof Long) {
            this.generator.writeNumber((Long)value);
        } else if (value instanceof Float) {
            this.generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.generator.writeNumber((Double)value);
        } else {
            this.generator.writeString((String)QueryDataType.VARCHAR.convert(value));
        }
    }

    @Override
    public void init() {
        this.baos.reset();
        try {
            this.generator = JSON_FACTORY.createGenerator(this.baos);
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public Object conclude() {
        try {
            this.generator.writeEndObject();
            this.generator.close();
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
        return this.baos.toByteArray();
    }
}

