/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class PortableUpsertTarget
implements UpsertTarget {
    private static final Object NOT_SET = new Object();
    private final ClassDefinition classDefinition;
    private final Object[] values;

    PortableUpsertTarget(@Nonnull ClassDefinition classDef) {
        this.classDefinition = classDef;
        this.values = new Object[classDef.getFieldCount()];
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        int fieldIndex = this.classDefinition.hasField(path) ? this.classDefinition.getField(path).getIndex() : -1;
        return value -> {
            if (fieldIndex == -1 && value != null) {
                throw QueryException.error("Unable to inject a non-null value to \"" + path + "\"");
            }
            if (fieldIndex > -1) {
                this.values[fieldIndex] = value;
            }
        };
    }

    @Override
    public void init() {
        Arrays.fill(this.values, NOT_SET);
    }

    @Override
    public Object conclude() {
        GenericRecord record = PortableUpsertTarget.toRecord(this.classDefinition, this.values);
        Arrays.fill(this.values, NOT_SET);
        return record;
    }

    private static GenericRecord toRecord(ClassDefinition classDefinition, Object[] values) {
        PortableGenericRecordBuilder portable = new PortableGenericRecordBuilder(classDefinition);
        for (int i = 0; i < classDefinition.getFieldCount(); ++i) {
            FieldDefinition fieldDefinition = classDefinition.getField(i);
            String name = fieldDefinition.getName();
            FieldType type = fieldDefinition.getType();
            Object value = values[i];
            try {
                switch (type) {
                    case BOOLEAN: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setBoolean(name, value != NOT_SET && (Boolean)value != false);
                        break;
                    }
                    case BYTE: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setByte(name, value == NOT_SET ? (byte)0 : (Byte)value);
                        break;
                    }
                    case SHORT: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setShort(name, value == NOT_SET ? (short)0 : (Short)value);
                        break;
                    }
                    case CHAR: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setChar(name, value == NOT_SET ? (char)'\u0000' : ((Character)value).charValue());
                        break;
                    }
                    case INT: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setInt(name, value == NOT_SET ? 0 : (Integer)value);
                        break;
                    }
                    case LONG: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setLong(name, value == NOT_SET ? 0L : (Long)value);
                        break;
                    }
                    case FLOAT: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setFloat(name, value == NOT_SET ? 0.0f : ((Float)value).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setDouble(name, value == NOT_SET ? 0.0 : (Double)value);
                        break;
                    }
                    case DECIMAL: {
                        portable.setDecimal(name, value == NOT_SET ? null : (BigDecimal)value);
                        break;
                    }
                    case UTF: {
                        portable.setString(name, value == NOT_SET ? null : (String)QueryDataType.VARCHAR.convert(value));
                        break;
                    }
                    case TIME: {
                        portable.setTime(name, value == NOT_SET ? null : (LocalTime)value);
                        break;
                    }
                    case DATE: {
                        portable.setDate(name, value == NOT_SET ? null : (LocalDate)value);
                        break;
                    }
                    case TIMESTAMP: {
                        portable.setTimestamp(name, value == NOT_SET ? null : (LocalDateTime)value);
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        portable.setTimestampWithTimezone(name, value == NOT_SET ? null : (OffsetDateTime)value);
                        break;
                    }
                    case PORTABLE: {
                        portable.setGenericRecord(name, value == NOT_SET ? null : (GenericRecord)value);
                        break;
                    }
                    case BOOLEAN_ARRAY: {
                        portable.setBooleanArray(name, value == NOT_SET ? null : (boolean[])value);
                        break;
                    }
                    case BYTE_ARRAY: {
                        portable.setByteArray(name, value == NOT_SET ? null : (byte[])value);
                        break;
                    }
                    case SHORT_ARRAY: {
                        portable.setShortArray(name, value == NOT_SET ? null : (short[])value);
                        break;
                    }
                    case CHAR_ARRAY: {
                        portable.setCharArray(name, value == NOT_SET ? null : (char[])value);
                        break;
                    }
                    case INT_ARRAY: {
                        portable.setIntArray(name, value == NOT_SET ? null : (int[])value);
                        break;
                    }
                    case LONG_ARRAY: {
                        portable.setLongArray(name, value == NOT_SET ? null : (long[])value);
                        break;
                    }
                    case FLOAT_ARRAY: {
                        portable.setFloatArray(name, value == NOT_SET ? null : (float[])value);
                        break;
                    }
                    case DOUBLE_ARRAY: {
                        portable.setDoubleArray(name, value == NOT_SET ? null : (double[])value);
                        break;
                    }
                    case DECIMAL_ARRAY: {
                        portable.setDecimalArray(name, value == NOT_SET ? null : (BigDecimal[])value);
                        break;
                    }
                    case UTF_ARRAY: {
                        portable.setStringArray(name, value == NOT_SET ? null : (String[])value);
                        break;
                    }
                    case TIME_ARRAY: {
                        portable.setTimeArray(name, value == NOT_SET ? null : (LocalTime[])value);
                        break;
                    }
                    case DATE_ARRAY: {
                        portable.setDateArray(name, value == NOT_SET ? null : (LocalDate[])value);
                        break;
                    }
                    case TIMESTAMP_ARRAY: {
                        portable.setTimestampArray(name, value == NOT_SET ? null : (LocalDateTime[])value);
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                        portable.setTimestampWithTimezoneArray(name, value == NOT_SET ? null : (OffsetDateTime[])value);
                        break;
                    }
                    case PORTABLE_ARRAY: {
                        portable.setGenericRecordArray(name, value == NOT_SET ? null : (GenericRecord[])value);
                        break;
                    }
                    default: {
                        throw QueryException.error("Unsupported type: " + (Object)((Object)type));
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw QueryException.error("Cannot set value " + (value == null ? "null" : " of type " + value.getClass().getName()) + " to field \"" + name + "\" of type " + (Object)((Object)type) + ": " + e.getMessage(), e);
            }
        }
        return portable.build();
    }

    private static void ensureNotNull(Object value) {
        if (value == null) {
            throw QueryException.error("Cannot set NULL to a primitive field");
        }
    }
}

