/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.prepare.RelOptTableImpl;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public final class OptUtils {
    private OptUtils() {
    }

    public static RelTraitSet toLogicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, JetConventions.LOGICAL);
    }

    public static RelNode toLogicalInput(RelNode rel) {
        return RelOptRule.convert(rel, OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, JetConventions.PHYSICAL);
    }

    public static RelNode toPhysicalInput(RelNode rel) {
        return RelOptRule.convert(rel, OptUtils.toPhysicalConvention(rel.getTraitSet()));
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait) {
        return traitSet.plus(trait).simplify();
    }

    public static LogicalTableScan createLogicalScan(RelOptCluster cluster, HazelcastTable hazelcastTable) {
        JetTable table = (JetTable)hazelcastTable.getTarget();
        HazelcastRelOptTable relTable = OptUtils.createRelTable(table.getQualifiedName(), hazelcastTable, cluster.getTypeFactory());
        return LogicalTableScan.create(cluster, relTable, ImmutableList.of());
    }

    public static HazelcastRelOptTable createRelTable(List<String> names, HazelcastTable hazelcastTable, RelDataTypeFactory typeFactory) {
        RelDataType rowType = hazelcastTable.getRowType(typeFactory);
        RelOptTableImpl relTable = RelOptTableImpl.create(null, rowType, names, hazelcastTable, null);
        return new HazelcastRelOptTable(relTable);
    }

    public static Collection<RelNode> extractPhysicalRelsFromSubset(RelNode node) {
        if (node instanceof RelSubset) {
            RelSubset subset = (RelSubset)node;
            HashSet<RelTraitSet> traitSets = new HashSet<RelTraitSet>();
            Set<RelNode> result = Collections.newSetFromMap(new IdentityHashMap());
            for (RelNode rel : subset.getRelList()) {
                if (!OptUtils.isPhysical(rel) || !traitSets.add(rel.getTraitSet())) continue;
                result.add(RelOptRule.convert(node, rel.getTraitSet()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isPhysical(RelNode rel) {
        return rel.getTraitSet().getTrait(ConventionTraitDef.INSTANCE).equals(JetConventions.PHYSICAL);
    }

    @Nonnull
    public static <T> T findMatchingRel(RelNode node, RelOptRuleOperand operandPredicate) {
        if (node instanceof RelSubset) {
            RelNode res = null;
            for (RelNode rel : ((RelSubset)node).getRels()) {
                if (!operandPredicate.matches(rel)) continue;
                if (res != null) {
                    throw new RuntimeException("multiple matches found");
                }
                res = rel;
            }
            if (res != null) {
                return (T)res;
            }
        } else if (operandPredicate.matches(node)) {
            return (T)node;
        }
        throw new RuntimeException("expected rel not found: " + node);
    }

    public static PlanNodeSchema schema(RelOptTable relTable) {
        Object table = relTable.unwrap(HazelcastTable.class).getTarget();
        ArrayList<QueryDataType> fieldTypes = new ArrayList<QueryDataType>();
        for (TableField field : ((Table)table).getFields()) {
            fieldTypes.add(field.getType());
        }
        return new PlanNodeSchema(fieldTypes);
    }

    public static PlanNodeSchema schema(RelDataType rowType) {
        return new PlanNodeSchema(OptUtils.extractFieldTypes(rowType));
    }

    public static RexVisitor<Expression<?>> createRexToExpressionVisitor(PlanNodeFieldTypeProvider schema, QueryParameterMetadata parameterMetadata) {
        return new RexToExpressionVisitor(schema, parameterMetadata);
    }

    public static RelDataType convert(TableField field, RelDataTypeFactory typeFactory) {
        QueryDataType fieldType = field.getType();
        SqlTypeName sqlTypeName = HazelcastTypeUtils.toCalciteType(fieldType);
        if (sqlTypeName == null) {
            throw new IllegalStateException("Unexpected type family: " + fieldType);
        }
        RelDataType relType = typeFactory.createSqlType(sqlTypeName);
        return typeFactory.createTypeWithNullability(relType, true);
    }

    private static List<QueryDataType> extractFieldTypes(RelDataType rowType) {
        return Util.toList(rowType.getFieldList(), f -> HazelcastTypeUtils.toHazelcastType(f.getType().getSqlTypeName()));
    }

    public static boolean hasTableType(TableScan scan, Class<? extends Table> tableClass) {
        HazelcastTable table = scan.getTable().unwrap(HazelcastTable.class);
        return table != null && tableClass.isAssignableFrom(table.getTarget().getClass());
    }
}

