/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.DeleteByKeyMapLogicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableModify;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.List;

public final class DeleteByKeyMapLogicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new DeleteByKeyMapLogicalRule();

    private DeleteByKeyMapLogicalRule() {
        super(DeleteByKeyMapLogicalRule.operandJ(LogicalTableModify.class, null, TableModify::isDelete, DeleteByKeyMapLogicalRule.operandJ(LogicalTableScan.class, null, delete -> OptUtils.hasTableType(delete, PartitionedMapTable.class), DeleteByKeyMapLogicalRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, DeleteByKeyMapLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalTableModify delete = (LogicalTableModify)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        HazelcastTable table = scan.getTable().unwrap(HazelcastTable.class);
        RexNode keyCondition = this.extractConstantExpression(table, delete.getCluster().getRexBuilder());
        if (keyCondition != null) {
            DeleteByKeyMapLogicalRel rel = new DeleteByKeyMapLogicalRel(delete.getCluster(), OptUtils.toLogicalConvention(delete.getTraitSet()), (PartitionedMapTable)table.getTarget(), keyCondition);
            call.transformTo(rel);
        }
    }

    private RexNode extractConstantExpression(HazelcastTable table, RexBuilder rexBuilder) {
        RexNode filter = table.getFilter();
        if (filter == null) {
            return null;
        }
        int keyIndex = this.findKeyIndex((Table)table.getTarget());
        switch (filter.getKind()) {
            case INPUT_REF: {
                return ((RexInputRef)filter).getIndex() == keyIndex ? rexBuilder.makeLiteral(true) : null;
            }
            case NOT: {
                RexNode operand = ((RexCall)filter).getOperands().get(0);
                return operand.getKind() == SqlKind.INPUT_REF && ((RexInputRef)operand).getIndex() == keyIndex ? rexBuilder.makeLiteral(false) : null;
            }
            case EQUALS: {
                Tuple2<Integer, RexNode> constantExpressionByIndex = this.extractConstantExpression((RexCall)filter);
                return constantExpressionByIndex != null && constantExpressionByIndex.getKey() == keyIndex ? constantExpressionByIndex.getValue() : null;
            }
        }
        return null;
    }

    private int findKeyIndex(Table table) {
        List<String> primaryKey = IMapSqlConnector.PRIMARY_KEY_LIST;
        assert (primaryKey.size() == 1);
        int keyIndex = table.getFieldIndex(primaryKey.get(0));
        assert (keyIndex > -1);
        return keyIndex;
    }

    private Tuple2<Integer, RexNode> extractConstantExpression(RexCall condition) {
        Tuple2<Integer, RexNode> constantExpression = this.extractConstantExpression(condition, 0);
        return constantExpression != null ? constantExpression : this.extractConstantExpression(condition, 1);
    }

    private Tuple2<Integer, RexNode> extractConstantExpression(RexCall condition, int i) {
        RexNode firstOperand = condition.getOperands().get(i);
        if (firstOperand.getKind() == SqlKind.INPUT_REF) {
            int index = ((RexInputRef)firstOperand).getIndex();
            RexNode secondOperand = condition.getOperands().get(1 - i);
            if (RexUtil.isConstant(secondOperand)) {
                return Tuple2.tuple2(index, secondOperand);
            }
        }
        return null;
    }
}

