/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.schema.JetDynamicTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetSpecificTableFunction;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class FullFunctionScanLogicalRules {
    static final RelOptRule SPECIFIC_FUNCTION_INSTANCE = new ConverterRule(LogicalTableFunctionScan.class, scan -> FullFunctionScanLogicalRules.extractSpecificFunction(scan) != null, (RelTrait)Convention.NONE, (RelTrait)Convention.NONE, FullFunctionScanLogicalRules.class.getSimpleName() + "(Specific)"){

        @Override
        public RelNode convert(RelNode rel) {
            LogicalTableFunctionScan scan = (LogicalTableFunctionScan)rel;
            return OptUtils.createLogicalScan(scan.getCluster(), this.extractTable(scan));
        }

        private HazelcastTable extractTable(LogicalTableFunctionScan scan) {
            JetSpecificTableFunction specificFunction = FullFunctionScanLogicalRules.extractSpecificFunction(scan);
            List<RexNode> operands = ((RexCall)scan.getCall()).getOperands();
            RexVisitor<Expression<?>> visitor = OptUtils.createRexToExpressionVisitor(PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER, ((HazelcastRelOptCluster)scan.getCluster()).getParameterMetadata());
            List<Expression<?>> argumentExpressions = IntStream.range(0, specificFunction.getOperandCountRange().getMax()).mapToObj(index -> index < operands.size() ? (Expression)((RexNode)operands.get(index)).accept(visitor) : null).collect(Collectors.toList());
            return specificFunction.toTable(argumentExpressions);
        }
    };
    static final RelOptRule DYNAMIC_FUNCTION_INSTANCE = new ConverterRule(LogicalTableFunctionScan.class, scan -> FullFunctionScanLogicalRules.extractDynamicFunction(scan) != null, (RelTrait)Convention.NONE, (RelTrait)Convention.NONE, FullFunctionScanLogicalRules.class.getSimpleName() + "(Dynamic)"){

        @Override
        public RelNode convert(RelNode rel) {
            LogicalTableFunctionScan scan = (LogicalTableFunctionScan)rel;
            return OptUtils.createLogicalScan(scan.getCluster(), this.extractTable(scan));
        }

        private HazelcastTable extractTable(LogicalTableFunctionScan scan) {
            JetDynamicTableFunction dynamicFunction = FullFunctionScanLogicalRules.extractDynamicFunction(scan);
            return dynamicFunction.toTable(scan.getRowType());
        }
    };

    private FullFunctionScanLogicalRules() {
    }

    private static JetSpecificTableFunction extractSpecificFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof JetSpecificTableFunction)) {
            return null;
        }
        return (JetSpecificTableFunction)call.getOperator();
    }

    private static JetDynamicTableFunction extractDynamicFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof JetDynamicTableFunction)) {
            return null;
        }
        return (JetDynamicTableFunction)call.getOperator();
    }
}

