/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateLogicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableModify;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class UpdateLogicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new UpdateLogicalRule();

    private UpdateLogicalRule() {
        super(UpdateLogicalRule.operandJ(LogicalTableModify.class, null, TableModify::isUpdate, UpdateLogicalRule.operand(LogicalProject.class, UpdateLogicalRule.operand(LogicalTableScan.class, UpdateLogicalRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, UpdateLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalTableModify update = (LogicalTableModify)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(2);
        UpdateLogicalRel rel = new UpdateLogicalRel(update.getCluster(), OptUtils.toLogicalConvention(update.getTraitSet()), update.getTable(), update.getCatalogReader(), UpdateLogicalRule.rewriteScan(scan), update.getUpdateColumnList(), update.getSourceExpressionList(), update.isFlattened());
        call.transformTo(rel);
    }

    private static RelNode rewriteScan(LogicalTableScan scan) {
        HazelcastRelOptTable relTable = (HazelcastRelOptTable)scan.getTable();
        HazelcastTable hazelcastTable = relTable.unwrap(HazelcastTable.class);
        return new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), OptUtils.createRelTable(relTable.getDelegate().getQualifiedName(), hazelcastTable.withProject(UpdateLogicalRule.keyProjects(hazelcastTable.getTarget())), scan.getCluster().getTypeFactory()));
    }

    private static List<Integer> keyProjects(Table table) {
        List<String> primaryKey = SqlConnectorUtil.getJetSqlConnector(table).getPrimaryKey(table);
        return IntStream.range(0, table.getFieldCount()).filter(i -> primaryKey.contains(((TableField)table.getField(i)).getName())).boxed().collect(Collectors.toList());
    }
}

