/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FilterLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FilterPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import java.util.Collection;

final class FilterPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new FilterPhysicalRule();

    private FilterPhysicalRule() {
        super(FilterPhysicalRule.operand(FilterLogicalRel.class, JetConventions.LOGICAL, FilterPhysicalRule.some(FilterPhysicalRule.operand(RelNode.class, FilterPhysicalRule.any()), new RelOptRuleOperand[0])), FilterPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FilterLogicalRel logicalFilter = (FilterLogicalRel)call.rel(0);
        RelNode input = logicalFilter.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            FilterPhysicalRel rel = new FilterPhysicalRel(logicalFilter.getCluster(), transformedInput.getTraitSet(), transformedInput, logicalFilter.getCondition());
            call.transformTo(rel);
        }
    }
}

