/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JoinNestedLoopPhysicalRel
extends Join
implements PhysicalRel {
    JoinNestedLoopPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, Collections.emptyList(), left, right, condition, Collections.emptySet(), joinType);
    }

    public Expression<Boolean> rightFilter(QueryParameterMetadata parameterMetadata) {
        return ((FullScanPhysicalRel)this.getRight()).filter(parameterMetadata);
    }

    public List<Expression<?>> rightProjection(QueryParameterMetadata parameterMetadata) {
        return ((FullScanPhysicalRel)this.getRight()).projection(parameterMetadata);
    }

    public JetJoinInfo joinInfo(QueryParameterMetadata parameterMetadata) {
        int[] leftKeys = this.analyzeCondition().leftKeys.toIntArray();
        HazelcastTable table = this.getRight().getTable().unwrap(HazelcastTable.class);
        List<Integer> projects = table.getProjects();
        int[] rightKeys = Arrays.stream(this.analyzeCondition().rightKeys.toIntArray()).map(projects::get).toArray();
        Expression<Boolean> nonEquiCondition = this.filter(this.schema(parameterMetadata), this.analyzeCondition().getRemaining(this.getCluster().getRexBuilder()), parameterMetadata);
        Expression<Boolean> condition = this.filter(this.schema(parameterMetadata), this.getCondition(), parameterMetadata);
        return new JetJoinInfo(this.getJoinType(), leftKeys, rightKeys, nonEquiCondition, condition);
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema leftSchema = ((PhysicalRel)this.getLeft()).schema(parameterMetadata);
        PlanNodeSchema rightSchema = ((PhysicalRel)this.getRight()).schema(parameterMetadata);
        return PlanNodeSchema.combine(leftSchema, rightSchema);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onNestedLoopJoin(this);
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new JoinNestedLoopPhysicalRel(this.getCluster(), traitSet, left, right, this.getCondition(), joinType);
    }
}

