/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.JoinLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import java.util.Collection;

public final class JoinPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new JoinPhysicalRule();

    private JoinPhysicalRule() {
        super(JoinPhysicalRule.operand(JoinLogicalRel.class, JetConventions.LOGICAL, JoinPhysicalRule.some(JoinPhysicalRule.operand(RelNode.class, JoinPhysicalRule.any()), JoinPhysicalRule.operand(RelNode.class, JoinPhysicalRule.any()))), JoinPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinLogicalRel logicalJoin = (JoinLogicalRel)call.rel(0);
        JoinRelType joinType = logicalJoin.getJoinType();
        assert (joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT);
        RelNode physicalLeft = OptUtils.toPhysicalInput(logicalJoin.getLeft());
        RelNode physicalRight = OptUtils.toPhysicalInput(logicalJoin.getRight());
        Collection<RelNode> lefts = OptUtils.extractPhysicalRelsFromSubset(physicalLeft);
        Collection<RelNode> rights = OptUtils.extractPhysicalRelsFromSubset(physicalRight);
        for (RelNode left : lefts) {
            for (RelNode right : rights) {
                JoinNestedLoopPhysicalRel rel = new JoinNestedLoopPhysicalRel(logicalJoin.getCluster(), OptUtils.toPhysicalConvention(logicalJoin.getTraitSet()), left, right, logicalJoin.getCondition(), logicalJoin.getJoinType());
                call.transformTo(rel);
            }
        }
    }
}

