/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.ProjectLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ProjectPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import java.util.Collection;

final class ProjectPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new ProjectPhysicalRule();

    private ProjectPhysicalRule() {
        super(ProjectPhysicalRule.operand(ProjectLogicalRel.class, JetConventions.LOGICAL, ProjectPhysicalRule.some(ProjectPhysicalRule.operand(RelNode.class, ProjectPhysicalRule.any()), new RelOptRuleOperand[0])), ProjectPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ProjectLogicalRel logicalProject = (ProjectLogicalRel)call.rel(0);
        RelNode input = logicalProject.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            ProjectPhysicalRel rel = new ProjectPhysicalRel(logicalProject.getCluster(), transformedInput.getTraitSet(), transformedInput, logicalProject.getProjects(), logicalProject.getRowType());
            call.transformTo(rel);
        }
    }
}

