/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlMappingColumn;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class SqlCreateMapping
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE EXTERNAL MAPPING", SqlKind.CREATE_TABLE);
    private final SqlIdentifier name;
    private final SqlIdentifier externalName;
    private final SqlNodeList columns;
    private final SqlIdentifier type;
    private final SqlNodeList options;

    public SqlCreateMapping(SqlIdentifier name, SqlIdentifier externalName, SqlNodeList columns, SqlIdentifier type, SqlNodeList options, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.externalName = externalName;
        this.columns = Objects.requireNonNull(columns, "Columns should not be null");
        this.type = Objects.requireNonNull(type, "Type should not be null");
        this.options = Objects.requireNonNull(options, "Options should not be null");
        Preconditions.checkTrue(externalName == null || externalName.isSimple(), externalName == null ? null : externalName.toString());
    }

    public String nameWithoutSchema() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public String externalName() {
        return this.externalName == null ? this.nameWithoutSchema() : this.externalName.getSimple();
    }

    public Stream<SqlMappingColumn> columns() {
        return this.columns.getList().stream().map(node -> (SqlMappingColumn)node);
    }

    public String type() {
        return this.type.toString();
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)node).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columns, this.type, this.options);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("EXTERNAL MAPPING");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columns.size() > 0) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode column : this.columns) {
                this.printIndent(writer);
                column.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.endList(frame);
        }
        writer.newlineAndIndent();
        writer.keyword("TYPE");
        this.type.unparse(writer, leftPrec, rightPrec);
        if (this.options.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("OPTIONS");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.options) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace() && this.ifNotExists) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.orReplaceWithIfNotExistsNotSupported());
        }
        if (!SqlCreateMapping.isMappingNameValid(this.name)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.mappingIncorrectSchema());
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (SqlNode column : this.columns.getList()) {
            String name = ((SqlMappingColumn)column).name();
            if (columnNames.add(name)) continue;
            throw validator.newValidationError(column, ParserResource.RESOURCE.duplicateColumn(name));
        }
        HashSet<String> optionNames = new HashSet<String>();
        for (SqlNode option : this.options.getList()) {
            String name = ((SqlOption)option).keyString();
            if (optionNames.add(name)) continue;
            throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(name));
        }
    }

    public static boolean isMappingNameValid(SqlIdentifier name) {
        return name.names.size() == 1 || name.names.size() == 2 && "public".equals(name.names.get(0)) || name.names.size() == 3 && "hazelcast".equals(name.names.get(0)) && "public".equals(name.names.get(1));
    }
}

