/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.SqlDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlMappingColumn
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN DECLARATION", SqlKind.COLUMN_DECL);
    private final SqlIdentifier name;
    private final SqlDataType type;
    private final SqlIdentifier externalName;

    public SqlMappingColumn(SqlIdentifier name, SqlDataType type, SqlIdentifier externalName, SqlParserPos pos) {
        super(pos);
        this.name = Objects.requireNonNull(name, "Column name should not be null");
        this.type = Objects.requireNonNull(type, "Column type should not be null");
        this.externalName = externalName;
    }

    public String name() {
        return this.name.getSimple();
    }

    public QueryDataType type() {
        return this.type != null ? this.type.type() : null;
    }

    public String externalName() {
        return this.externalName == null ? null : this.externalName.toString();
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.type, this.externalName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.type != null) {
            this.type.unparse(writer, leftPrec, rightPrec);
        }
        if (this.externalName != null) {
            writer.keyword("EXTERNAL NAME");
            this.externalName.unparse(writer, leftPrec, rightPrec);
        }
    }
}

