/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.schema.UnknownStatistic;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeComparability;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.org.apache.calcite.rel.type.StructKind;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.NlsString;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.schema.Table;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class JetDynamicTableFunction
extends JetTableFunction {
    protected JetDynamicTableFunction(String name, List<JetTableFunctionParameter> parameters, Function<List<Object>, Table> tableFn, SqlOperandTypeInference operandTypeInference, SqlConnector connector) {
        super(name, parameters, (SqlOperatorBinding binding) -> JetDynamicTableFunction.inferReturnType(name, parameters, tableFn, binding), operandTypeInference, connector);
        assert (parameters.stream().map(JetTableFunctionParameter::type).allMatch(type -> type == SqlTypeName.VARCHAR || type == SqlTypeName.MAP));
    }

    public final HazelcastTable toTable(RelDataType rowType) {
        return ((JetFunctionRelDataType)rowType).table();
    }

    private static RelDataType inferReturnType(String name, List<JetTableFunctionParameter> parameters, Function<List<Object>, Table> tableFn, SqlOperatorBinding callBinding) {
        List<Object> arguments = JetDynamicTableFunction.toArguments(name, parameters, callBinding);
        HazelcastTable table = new HazelcastTable(tableFn.apply(arguments), UnknownStatistic.INSTANCE);
        RelDataType rowType = table.getRowType(callBinding.getTypeFactory());
        return new JetFunctionRelDataType(table, rowType);
    }

    private static List<Object> toArguments(String functionName, List<JetTableFunctionParameter> parameters, SqlOperatorBinding callBinding) {
        SqlCallBinding binding = (SqlCallBinding)callBinding;
        SqlCall call = binding.getCall();
        HazelcastSqlValidator validator = (HazelcastSqlValidator)binding.getValidator();
        return ValidationUtil.hasAssignment(call) ? JetDynamicTableFunction.fromNamedArguments(functionName, parameters, call, validator) : JetDynamicTableFunction.fromPositionalArguments(functionName, parameters, call, validator);
    }

    private static List<Object> fromNamedArguments(String functionName, List<JetTableFunctionParameter> parameters, SqlCall call, HazelcastSqlValidator validator) {
        ArrayList<Object> arguments = new ArrayList<Object>(parameters.size());
        for (JetTableFunctionParameter parameter : parameters) {
            SqlNode operand = JetDynamicTableFunction.findOperandByName(parameter.name(), call);
            Object value = operand == null ? null : JetDynamicTableFunction.extractValue(functionName, parameter, operand, validator);
            arguments.add(value);
        }
        return arguments;
    }

    private static SqlNode findOperandByName(String name, SqlCall call) {
        for (int i = 0; i < call.operandCount(); ++i) {
            SqlCall assignment = (SqlCall)call.operand(i);
            SqlIdentifier id = (SqlIdentifier)assignment.operand(1);
            if (!name.equals(id.getSimple())) continue;
            return assignment.operand(0);
        }
        return null;
    }

    private static List<Object> fromPositionalArguments(String functionName, List<JetTableFunctionParameter> parameters, SqlCall call, HazelcastSqlValidator validator) {
        int i;
        ArrayList<Object> arguments = new ArrayList<Object>(parameters.size());
        for (i = 0; i < call.operandCount(); ++i) {
            Object value = JetDynamicTableFunction.extractValue(functionName, parameters.get(i), call.operand(i), validator);
            arguments.add(value);
        }
        for (i = call.operandCount(); i < parameters.size(); ++i) {
            arguments.add(null);
        }
        return arguments;
    }

    private static Object extractValue(String functionName, JetTableFunctionParameter parameter, SqlNode operand, HazelcastSqlValidator validator) {
        if (operand.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        if (SqlUtil.isNullLiteral(operand, true)) {
            return null;
        }
        if (operand.getKind() == SqlKind.DYNAMIC_PARAM) {
            return validator.getArgumentAt(((SqlDynamicParam)operand).getIndex());
        }
        SqlTypeName parameterType = parameter.type();
        if (SqlUtil.isLiteral(operand) && parameterType == SqlTypeName.VARCHAR) {
            String value = JetDynamicTableFunction.extractStringValue((SqlLiteral)operand);
            if (value != null) {
                return value;
            }
        } else if (operand.getKind() == SqlKind.MAP_VALUE_CONSTRUCTOR && parameterType == SqlTypeName.MAP) {
            return JetDynamicTableFunction.extractMapValue(functionName, parameter, (SqlCall)operand, validator);
        }
        throw QueryException.error("Invalid argument of a call to function " + functionName + " - #" + parameter.ordinal() + " (" + parameter.name() + "). Expected: " + (Object)((Object)parameterType) + ", actual: " + (SqlUtil.isLiteral(operand) ? ((SqlLiteral)operand).getTypeName() : operand.getKind()));
    }

    private static String extractStringValue(SqlLiteral literal) {
        Object value = literal.getValue();
        return value instanceof NlsString ? ((NlsString)value).getValue() : null;
    }

    private static Map<String, String> extractMapValue(String functionName, JetTableFunctionParameter parameter, SqlCall call, HazelcastSqlValidator validator) {
        List<SqlNode> operands = call.getOperandList();
        HashMap<String, String> entries = new HashMap<String, String>();
        for (int i = 0; i < operands.size(); i += 2) {
            String value;
            String key = JetDynamicTableFunction.extractMapStringValue(functionName, parameter, operands.get(i), validator);
            if (entries.putIfAbsent(key, value = JetDynamicTableFunction.extractMapStringValue(functionName, parameter, operands.get(i + 1), validator)) == null) continue;
            throw QueryException.error("Duplicate entry in the MAP constructor in the call to function " + functionName + " - argument #" + parameter.ordinal() + " (" + parameter.name() + ")");
        }
        return entries;
    }

    private static String extractMapStringValue(String functionName, JetTableFunctionParameter parameter, SqlNode node, HazelcastSqlValidator validator) {
        SqlLiteral literal;
        Object value;
        Object value2;
        if (node.getKind() == SqlKind.DYNAMIC_PARAM && (value2 = validator.getArgumentAt(((SqlDynamicParam)node).getIndex())) instanceof String) {
            return (String)value2;
        }
        if (SqlUtil.isLiteral(node) && (value = (literal = (SqlLiteral)node).getValue()) instanceof NlsString) {
            return ((NlsString)value).getValue();
        }
        throw QueryException.error("All values in the MAP constructor of the call to function " + functionName + ", argument #" + parameter.ordinal() + " (" + parameter.name() + ") must be VARCHAR literals. Actual argument is: " + (SqlUtil.isLiteral(node) ? ((SqlLiteral)node).getTypeName() : node.getKind()));
    }

    private static final class JetFunctionRelDataType
    implements RelDataType {
        private final HazelcastTable table;
        private final RelDataType delegate;

        private JetFunctionRelDataType(HazelcastTable table, RelDataType delegate) {
            this.delegate = delegate;
            this.table = table;
        }

        private HazelcastTable table() {
            return this.table;
        }

        @Override
        public boolean isStruct() {
            return this.delegate.isStruct();
        }

        @Override
        public List<RelDataTypeField> getFieldList() {
            return this.delegate.getFieldList();
        }

        @Override
        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }

        @Override
        public int getFieldCount() {
            return this.delegate.getFieldCount();
        }

        @Override
        public StructKind getStructKind() {
            return this.delegate.getStructKind();
        }

        @Override
        public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
            return this.delegate.getField(fieldName, caseSensitive, elideRecord);
        }

        @Override
        public boolean isNullable() {
            return this.delegate.isNullable();
        }

        @Override
        public RelDataType getComponentType() {
            return this.delegate.getComponentType();
        }

        @Override
        public RelDataType getKeyType() {
            return this.delegate.getKeyType();
        }

        @Override
        public RelDataType getValueType() {
            return this.delegate.getValueType();
        }

        @Override
        public Charset getCharset() {
            return this.delegate.getCharset();
        }

        @Override
        public SqlCollation getCollation() {
            return this.delegate.getCollation();
        }

        @Override
        public SqlIntervalQualifier getIntervalQualifier() {
            return this.delegate.getIntervalQualifier();
        }

        @Override
        public int getPrecision() {
            return this.delegate.getPrecision();
        }

        @Override
        public int getScale() {
            return this.delegate.getScale();
        }

        @Override
        public SqlTypeName getSqlTypeName() {
            return this.delegate.getSqlTypeName();
        }

        @Override
        public SqlIdentifier getSqlIdentifier() {
            return this.delegate.getSqlIdentifier();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String getFullTypeString() {
            return this.delegate.getFullTypeString();
        }

        @Override
        public RelDataTypeFamily getFamily() {
            return this.delegate.getFamily();
        }

        @Override
        public RelDataTypePrecedenceList getPrecedenceList() {
            return this.delegate.getPrecedenceList();
        }

        @Override
        public RelDataTypeComparability getComparability() {
            return this.delegate.getComparability();
        }

        @Override
        public boolean isDynamicStruct() {
            return this.delegate.isDynamicStruct();
        }
    }
}

