/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.operand.NamedOperandCheckerProgram;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class JetTableFunction
extends HazelcastFunction {
    private final SqlConnector connector;
    private final List<String> parameterNames;
    private final OperandChecker[] checkers;

    protected JetTableFunction(String name, List<JetTableFunctionParameter> parameters, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlConnector connector) {
        super(name, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION);
        this.connector = connector;
        this.parameterNames = parameters.stream().map(JetTableFunctionParameter::name).collect(Collectors.toList());
        this.checkers = (OperandChecker[])parameters.stream().map(JetTableFunctionParameter::checker).toArray(OperandChecker[]::new);
    }

    public final boolean isStream() {
        return this.connector.isStream();
    }

    @Override
    public final List<String> getParamNames() {
        return this.parameterNames;
    }

    @Override
    protected final boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (ValidationUtil.hasAssignment(binding.getCall())) {
            return new NamedOperandCheckerProgram(this.checkers).check(binding, throwOnFailure);
        }
        OperandChecker[] checkers = Arrays.copyOfRange(this.checkers, 0, binding.getOperandCount());
        return new OperandCheckerProgram(checkers).check(binding, throwOnFailure);
    }
}

