/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingColumnsTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingsTable;
import com.hazelcast.jet.sql.impl.schema.MappingStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MappingCatalog
implements TableResolver {
    public static final String SCHEMA_NAME_PUBLIC = "public";
    public static final String SCHEMA_NAME_INFORMATION_SCHEMA = "information_schema";
    private static final List<List<String>> SEARCH_PATHS = Collections.singletonList(Arrays.asList("hazelcast", "public"));
    private final NodeEngine nodeEngine;
    private final MappingStorage storage;
    private final SqlConnectorCache connectorCache;
    private final List<TableResolver.TableListener> listeners;

    public MappingCatalog(NodeEngine nodeEngine, MappingStorage storage, SqlConnectorCache connectorCache) {
        this.nodeEngine = nodeEngine;
        this.storage = storage;
        this.connectorCache = connectorCache;
        this.listeners = new CopyOnWriteArrayList<TableResolver.TableListener>();
        this.storage.registerListener(new MappingStorage.EntryListenerAdapter(){

            @Override
            public void entryUpdated(EntryEvent<String, Mapping> event) {
                if (!event.getMember().localMember()) {
                    MappingCatalog.this.listeners.forEach(TableResolver.TableListener::onTableChanged);
                }
            }

            @Override
            public void entryRemoved(EntryEvent<String, Mapping> event) {
                if (!event.getMember().localMember()) {
                    MappingCatalog.this.listeners.forEach(TableResolver.TableListener::onTableChanged);
                }
            }
        });
    }

    public void createMapping(Mapping mapping, boolean replace, boolean ifNotExists) {
        Mapping resolved = this.resolveMapping(mapping);
        String name = resolved.name();
        if (ifNotExists) {
            this.storage.putIfAbsent(name, resolved);
        } else if (replace) {
            this.storage.put(name, resolved);
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        } else if (!this.storage.putIfAbsent(name, resolved)) {
            throw QueryException.error("Mapping already exists: " + name);
        }
    }

    private Mapping resolveMapping(Mapping mapping) {
        String type = mapping.type();
        Map<String, String> options = mapping.options();
        SqlConnector connector = this.connectorCache.forType(type);
        List<MappingField> resolvedFields = connector.resolveAndValidateFields(this.nodeEngine, options, mapping.fields());
        return new Mapping(mapping.name(), mapping.externalName(), type, new ArrayList<MappingField>(resolvedFields), new LinkedHashMap<String, String>(options));
    }

    public void removeMapping(String name, boolean ifExists) {
        if (this.storage.remove(name) != null) {
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        } else if (!ifExists) {
            throw QueryException.error("Mapping does not exist: " + name);
        }
    }

    @Nonnull
    public List<String> getMappingNames() {
        return this.storage.values().stream().map(Mapping::name).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<List<String>> getDefaultSearchPaths() {
        return SEARCH_PATHS;
    }

    @Override
    @Nonnull
    public List<Table> getTables() {
        Collection<Mapping> mappings = this.storage.values();
        ArrayList<Table> tables = new ArrayList<Table>(mappings.size() + 2);
        for (Mapping mapping : mappings) {
            tables.add(this.toTable(mapping));
        }
        tables.add(new MappingsTable("hazelcast", SCHEMA_NAME_INFORMATION_SCHEMA, SCHEMA_NAME_PUBLIC, mappings));
        tables.add(new MappingColumnsTable("hazelcast", SCHEMA_NAME_INFORMATION_SCHEMA, SCHEMA_NAME_PUBLIC, mappings));
        return tables;
    }

    private Table toTable(Mapping mapping) {
        SqlConnector connector = this.connectorCache.forType(mapping.type());
        return connector.createTable(this.nodeEngine, SCHEMA_NAME_PUBLIC, mapping.name(), mapping.externalName(), mapping.options(), mapping.fields());
    }

    @Override
    public void registerListener(TableResolver.TableListener listener) {
        this.listeners.add(listener);
    }
}

