/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.jet.sql.impl.validate.JetSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDelete;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.schema.Table;
import java.util.List;

public class JetSqlValidator
extends HazelcastSqlValidator {
    private boolean isCreateJob;
    private boolean isInfiniteRows;

    public JetSqlValidator(SqlValidatorCatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance, List<Object> arguments) {
        super(JetSqlOperatorTable.instance(), catalogReader, typeFactory, conformance, arguments);
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        if (topNode instanceof SqlCreateJob) {
            this.isCreateJob = true;
        }
        if (topNode.getKind().belongsTo(SqlKind.DDL)) {
            topNode.validate(this, this.getEmptyScope());
            return topNode;
        }
        if (topNode instanceof SqlShowStatement) {
            return topNode;
        }
        return super.validate(topNode);
    }

    @Override
    protected void validateSelect(SqlSelect select, SqlValidatorScope scope) {
        SqlNode offset;
        SqlNode fetch = select.getFetch();
        if (fetch != null) {
            this.deriveType(scope, fetch);
            fetch.validate(this, this.getEmptyScope());
        }
        if ((offset = select.getOffset()) != null) {
            this.deriveType(scope, offset);
            offset.validate(this, this.getEmptyScope());
        }
    }

    @Override
    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        super.validateFrom(node, targetRowType, scope);
        this.isInfiniteRows = this.containsStreamingSource(node);
    }

    @Override
    protected void validateGroupClause(SqlSelect select) {
        super.validateGroupClause(select);
        if (this.containsGroupingOrAggregation(select) && this.isInfiniteRows(select)) {
            throw this.newValidationError(select, ValidatorResource.RESOURCE.streamingAggregationsNotSupported());
        }
    }

    private boolean containsGroupingOrAggregation(SqlSelect select) {
        if (select.getGroup() != null && select.getGroup().size() > 0) {
            return true;
        }
        if (select.isDistinct()) {
            return true;
        }
        for (SqlNode node : select.getSelectList()) {
            if (!node.getKind().belongsTo(SqlKind.AGGREGATE)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void validateOrderList(SqlSelect select) {
        super.validateOrderList(select);
        if (select.hasOrderBy() && this.isInfiniteRows(select)) {
            throw this.newValidationError(select, ValidatorResource.RESOURCE.streamingSortingNotSupported());
        }
    }

    @Override
    protected void validateJoin(final SqlJoin join, SqlValidatorScope scope) {
        super.validateJoin(join, scope);
        join.getRight().accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                if (call.getKind() == SqlKind.SELECT) {
                    throw JetSqlValidator.this.newValidationError(join, ValidatorResource.RESOURCE.joiningSubqueryNotSupported());
                }
                if (call.getKind() == SqlKind.VALUES) {
                    throw JetSqlValidator.this.newValidationError(join, ValidatorResource.RESOURCE.joiningValuesNotSupported());
                }
                return call.getOperator().acceptCall(this, call);
            }
        });
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        super.validateInsert(insert);
        if (!this.isCreateJob && this.isInfiniteRows(insert.getSource())) {
            throw this.newValidationError(insert, ValidatorResource.RESOURCE.mustUseCreateJob());
        }
    }

    @Override
    protected SqlSelect createSourceSelectForUpdate(SqlUpdate update) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        Table table = this.extractTable((SqlIdentifier)update.getTargetTable());
        if (table != null) {
            SqlConnector connector = SqlConnectorUtil.getJetSqlConnector(table);
            if (connector.getPrimaryKey(table).isEmpty()) {
                throw QueryException.error("Cannot UPDATE " + update.getTargetTable() + ": it doesn't have a primary key");
            }
            table.getFields().forEach(field -> selectList.add(new SqlIdentifier(field.getName(), SqlParserPos.ZERO)));
        }
        int ordinal = 0;
        for (SqlNode exp : update.getSourceExpressionList()) {
            String alias = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias));
            ++ordinal;
        }
        SqlNode sourceTable = update.getTargetTable();
        if (update.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, update.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, update.getCondition(), null, null, null, null, null, null, null);
    }

    @Override
    public void validateUpdate(final SqlUpdate update) {
        super.validateUpdate(update);
        SqlNodeList selectList = update.getSourceSelect().getSelectList();
        SqlNodeList sourceExpressionList = update.getSourceExpressionList();
        for (int i = 0; i < sourceExpressionList.size(); ++i) {
            update.getSourceExpressionList().set(i, selectList.get(selectList.size() - sourceExpressionList.size() + i));
        }
        update.getSourceSelect().getSelectList().accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                if (call.getKind() == SqlKind.SELECT) {
                    throw JetSqlValidator.this.newValidationError(update, ValidatorResource.RESOURCE.updateFromSelectNotSupported());
                }
                return call.getOperator().acceptCall(this, call);
            }
        });
    }

    @Override
    protected SqlSelect createSourceSelectForDelete(SqlDelete delete) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        Table table = this.extractTable((SqlIdentifier)delete.getTargetTable());
        if (table != null) {
            SqlConnector connector = SqlConnectorUtil.getJetSqlConnector(table);
            connector.getPrimaryKey(table).forEach(name -> selectList.add(new SqlIdentifier((String)name, SqlParserPos.ZERO)));
            if (selectList.size() == 0) {
                throw QueryException.error("Cannot DELETE from " + delete.getTargetTable() + ": it doesn't have a primary key");
            }
        }
        SqlNode sourceTable = delete.getTargetTable();
        if (delete.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, delete.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, delete.getCondition(), null, null, null, null, null, null, null);
    }

    private Table extractTable(SqlIdentifier identifier) {
        SqlValidatorTable validatorTable = this.getCatalogReader().getTable(identifier.names);
        return validatorTable == null ? null : (Table)validatorTable.unwrap(HazelcastTable.class).getTarget();
    }

    @Override
    public boolean isInfiniteRows() {
        return this.isInfiniteRows;
    }

    private boolean isInfiniteRows(SqlNode node) {
        this.isInfiniteRows |= this.containsStreamingSource(node);
        return this.isInfiniteRows;
    }

    private boolean containsStreamingSource(SqlNode node) {
        class FindStreamingTablesVisitor
        extends SqlBasicVisitor<Void> {
            boolean found;

            FindStreamingTablesVisitor() {
            }

            @Override
            public Void visit(SqlIdentifier id) {
                HazelcastTable hazelcastTable;
                SqlConnector connector;
                SqlValidatorTable table = JetSqlValidator.this.getCatalogReader().getTable(id.names);
                if (table != null && (connector = SqlConnectorUtil.getJetSqlConnector((hazelcastTable = table.unwrap(HazelcastTable.class)).getTarget())).isStream()) {
                    this.found = true;
                    return null;
                }
                return (Void)super.visit(id);
            }

            @Override
            public Void visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator instanceof JetTableFunction && ((JetTableFunction)operator).isStream()) {
                    this.found = true;
                    return null;
                }
                return (Void)super.visit(call);
            }
        }
        FindStreamingTablesVisitor visitor = new FindStreamingTablesVisitor();
        node.accept(visitor);
        return visitor.found;
    }
}

