/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operand;

import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;

public class NamedOperandCheckerProgram {
    private final OperandChecker[] checkers;

    public NamedOperandCheckerProgram(OperandChecker ... checkers) {
        this.checkers = checkers;
    }

    public boolean check(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        boolean res = true;
        SqlCall call = callBinding.getCall();
        SqlFunction operator = (SqlFunction)call.getOperator();
        for (int i = 0; i < call.operandCount(); ++i) {
            Object operand = call.operand(i);
            assert (((SqlNode)operand).getKind() == SqlKind.ARGUMENT_ASSIGNMENT);
            SqlIdentifier id = (SqlIdentifier)((SqlCall)operand).operand(1);
            OperandChecker checker = this.findOperandChecker(id, operator);
            res &= checker.check(callBinding, false, i);
        }
        if (!res && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return res;
    }

    private OperandChecker findOperandChecker(SqlIdentifier identifier, SqlFunction operator) {
        String name = identifier.getSimple();
        for (int i = 0; i < operator.getParamNames().size(); ++i) {
            String paramName = operator.getParamNames().get(i);
            if (!paramName.equals(name)) continue;
            return this.checkers[i];
        }
        throw SqlUtil.newContextException(identifier.getParserPosition(), ValidatorResource.RESOURCE.unknownArgumentName(name));
    }
}

