/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastSpecialOperator;
import java.util.List;

public class HazelcastMapValueConstructor
extends HazelcastSpecialOperator {
    public HazelcastMapValueConstructor() {
        super("MAP", SqlKind.MAP_VALUE_CONSTRUCTOR, 200, false, HazelcastMapValueConstructor::inferReturnType0, new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY));
    }

    private static RelDataType inferReturnType0(SqlOperatorBinding binding) {
        Pair<RelDataType, RelDataType> entryType = HazelcastMapValueConstructor.findEntryType(binding.getTypeFactory(), binding.collectOperandTypes());
        return SqlTypeUtil.createMapType(binding.getTypeFactory(), (RelDataType)entryType.left, (RelDataType)entryType.right, false);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        boolean result = HazelcastMapValueConstructor.checkOperandTypes(callBinding);
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.operands());
        if (argTypes.size() == 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresTwoOrMoreArgs());
        }
        if (argTypes.size() % 2 > 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresEvenArgCount());
        }
        Pair<RelDataType, RelDataType> entryType = HazelcastMapValueConstructor.findEntryType(callBinding.getTypeFactory(), argTypes);
        if (entryType.left == null || entryType.right == null) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return result;
    }

    private static boolean checkOperandTypes(HazelcastCallBinding callBinding) {
        boolean result = true;
        for (int i = 0; i < callBinding.getOperandCount(); ++i) {
            result &= TypedOperandChecker.VARCHAR.check(callBinding, false, i);
        }
        return result;
    }

    private static Pair<RelDataType, RelDataType> findEntryType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
    }
}

