/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators;

import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HazelcastOperandTypeInference
implements SqlOperandTypeInference {
    private final Map<String, JetTableFunctionParameter> parametersByName;
    private final SqlOperandTypeInference positionalOperandTypeInference;

    public HazelcastOperandTypeInference(List<JetTableFunctionParameter> parameters, SqlOperandTypeInference positionalOperandTypeInference) {
        this.parametersByName = parameters.stream().collect(Collectors.toMap(JetTableFunctionParameter::name, Function.identity()));
        this.positionalOperandTypeInference = positionalOperandTypeInference;
    }

    @Override
    public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
        SqlCall call = callBinding.getCall();
        if (ValidationUtil.hasAssignment(call)) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < call.operandCount(); ++i) {
                SqlCall assignment = (SqlCall)call.operand(i);
                SqlIdentifier id = (SqlIdentifier)assignment.operand(1);
                String name = id.getSimple();
                JetTableFunctionParameter parameter = this.parametersByName.get(name);
                if (parameter == null) {
                    throw SqlUtil.newContextException(id.getParserPosition(), ValidatorResource.RESOURCE.unknownArgumentName(name));
                }
                SqlTypeName parameterType = parameter.type();
                operandTypes[i] = HazelcastOperandTypeInference.toType(parameterType, typeFactory);
            }
        } else {
            this.positionalOperandTypeInference.inferOperandTypes(callBinding, returnType, operandTypes);
        }
    }

    private static RelDataType toType(SqlTypeName parameterType, RelDataTypeFactory typeFactory) {
        if (parameterType == SqlTypeName.MAP) {
            RelDataType sqlType = typeFactory.createUnknownType();
            return typeFactory.createMapType(sqlType, sqlType);
        }
        RelDataType sqlType = typeFactory.createSqlType(parameterType);
        return sqlType.isNullable() ? HazelcastTypeUtils.createNullableType(typeFactory, sqlType) : sqlType;
    }
}

