/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.iteration.IndexIterationPointer;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MapFetchIndexOperation
extends MapOperation
implements ReadonlyOperation {
    private static final int EXCESS_ENTRIES_RESERVE = 128;
    private String indexName;
    private PartitionIdSet partitionIdSet;
    private IndexIterationPointer[] pointers;
    private int sizeHint;
    private transient MapFetchIndexOperationResult response;

    public MapFetchIndexOperation() {
    }

    public MapFetchIndexOperation(String mapName, String indexName, IndexIterationPointer[] pointers, PartitionIdSet partitionIdSet, int sizeHint) {
        super(mapName);
        this.indexName = indexName;
        this.partitionIdSet = partitionIdSet;
        this.pointers = pointers;
        this.sizeHint = sizeHint;
    }

    @Override
    protected void runInternal() {
        Indexes indexes = this.mapContainer.getIndexes();
        if (indexes == null) {
            throw new QueryException("Cannot use the index \"" + this.indexName + "\" of the IMap \"" + this.name + "\" because it is not global (make sure the property \"" + ClusterProperty.GLOBAL_HD_INDEX_ENABLED + "\" is set to \"true\")");
        }
        InternalIndex index = indexes.getIndex(this.indexName);
        if (index == null) {
            throw new QueryException("Index \"" + this.indexName + "\" does not exist");
        }
        GlobalIndexPartitionTracker.PartitionStamp indexStamp = index.getPartitionStamp();
        if (indexStamp == null) {
            throw new MissingPartitionException("index is being rebuilt");
        }
        if (indexStamp.partitions.equals(this.partitionIdSet)) {
            this.partitionIdSet = null;
        } else if (!indexStamp.partitions.containsAll(this.partitionIdSet)) {
            throw new MissingPartitionException("some requested partitions are not indexed");
        }
        switch (index.getConfig().getType()) {
            case HASH: {
                this.response = this.runInternalHash(index);
                break;
            }
            case SORTED: {
                this.response = this.runInternalSorted(index);
                break;
            }
            case BITMAP: {
                throw new UnsupportedOperationException("BITMAP index scan is not implemented");
            }
            default: {
                throw new UnsupportedOperationException("Unknown index type: \"" + index.getConfig().getType().name() + "\"");
            }
        }
        if (!index.validatePartitionStamp(indexStamp.stamp)) {
            throw new MissingPartitionException("partition timestamp has changed");
        }
    }

    private MapFetchIndexOperationResult runInternalSorted(InternalIndex index) {
        ArrayList entries = new ArrayList(this.sizeHint + 128);
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        for (int i = 0; i < this.pointers.length; ++i) {
            IndexIterationPointer pointer = this.pointers[i];
            Iterator<IndexKeyEntries> entryIterator = MapFetchIndexOperation.getEntryIterator(index, pointer);
            while (entryIterator.hasNext()) {
                IndexIterationPointer[] newPointers;
                IndexKeyEntries indexKeyEntries = entryIterator.next();
                Collection<QueryableEntry> keyEntries = indexKeyEntries.getEntries();
                if (this.partitionIdSet == null) {
                    entries.addAll(keyEntries);
                } else {
                    for (QueryableEntry entry : keyEntries) {
                        int partitionId = HashUtil.hashToIndex(entry.getKeyData().getPartitionHash(), partitionCount);
                        if (!this.partitionIdSet.contains(partitionId)) continue;
                        entries.add(entry);
                    }
                }
                if (entries.size() < this.sizeHint) continue;
                if (entryIterator.hasNext()) {
                    Comparable<?> currentIndexKey = indexKeyEntries.getIndexKey();
                    newPointers = new IndexIterationPointer[this.pointers.length - i];
                    newPointers[0] = IndexIterationPointer.create(pointer.isDescending() ? pointer.getFrom() : currentIndexKey, pointer.isDescending() ? pointer.isFromInclusive() : false, pointer.isDescending() ? currentIndexKey : pointer.getTo(), pointer.isDescending() ? false : pointer.isToInclusive(), pointer.isDescending());
                    System.arraycopy(this.pointers, i + 1, newPointers, 1, newPointers.length - 1);
                } else {
                    newPointers = new IndexIterationPointer[this.pointers.length - i - 1];
                    System.arraycopy(this.pointers, i + 1, newPointers, 0, newPointers.length);
                }
                return new MapFetchIndexOperationResult(entries, newPointers);
            }
        }
        return new MapFetchIndexOperationResult(entries, new IndexIterationPointer[0]);
    }

    private static Iterator<IndexKeyEntries> getEntryIterator(InternalIndex index, IndexIterationPointer pointer) {
        Iterator<IndexKeyEntries> entryIterator;
        if (pointer.getFrom() != null) {
            if (pointer.getTo() != null) {
                if (pointer.getFrom().compareTo(pointer.getTo()) == 0) {
                    assert (pointer.isFromInclusive() && pointer.isToInclusive()) : "If range scan is a point lookup then limits should be all inclusive";
                    entryIterator = index.getSqlRecordIteratorBatch(pointer.getFrom());
                } else {
                    entryIterator = index.getSqlRecordIteratorBatch(pointer.getFrom(), pointer.isFromInclusive(), pointer.getTo(), pointer.isToInclusive(), pointer.isDescending());
                }
            } else {
                entryIterator = index.getSqlRecordIteratorBatch(pointer.isFromInclusive() ? Comparison.GREATER_OR_EQUAL : Comparison.GREATER, pointer.getFrom(), pointer.isDescending());
            }
        } else {
            entryIterator = pointer.getTo() != null ? index.getSqlRecordIteratorBatch(pointer.isToInclusive() ? Comparison.LESS_OR_EQUAL : Comparison.LESS, pointer.getTo(), pointer.isDescending()) : index.getSqlRecordIteratorBatch(pointer.isDescending());
        }
        return entryIterator;
    }

    private MapFetchIndexOperationResult runInternalHash(InternalIndex index) {
        int pointerIndex;
        ArrayList entries = new ArrayList();
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        for (pointerIndex = 0; pointerIndex < this.pointers.length && entries.size() < this.sizeHint; ++pointerIndex) {
            IndexIterationPointer pointer = this.pointers[pointerIndex];
            assert (pointer.getFrom() == pointer.getTo()) : "Unordered index iteration pointer must have same from and to values";
            Set<QueryableEntry> keyEntries = index.getRecords(pointer.getFrom());
            if (this.partitionIdSet == null) {
                entries.addAll(keyEntries);
                continue;
            }
            for (QueryableEntry entry : keyEntries) {
                int partitionId = HashUtil.hashToIndex(entry.getKeyData().getPartitionHash(), partitionCount);
                if (!this.partitionIdSet.contains(partitionId)) continue;
                entries.add(entry);
            }
        }
        IndexIterationPointer[] newPointers = new IndexIterationPointer[this.pointers.length - pointerIndex];
        System.arraycopy(this.pointers, pointerIndex, newPointers, 0, newPointers.length);
        return new MapFetchIndexOperationResult(entries, newPointers);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.indexName = in.readString();
        this.partitionIdSet = (PartitionIdSet)in.readObject();
        this.pointers = (IndexIterationPointer[])in.readObject();
        this.sizeHint = in.readInt();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.indexName);
        out.writeObject(this.partitionIdSet);
        out.writeObject(this.pointers);
        out.writeInt(this.sizeHint);
    }

    @Override
    public int getClassId() {
        return 155;
    }

    public static final class MissingPartitionException
    extends HazelcastException {
        public MissingPartitionException(String message) {
            super(message);
        }
    }

    public static final class MapFetchIndexOperationResult {
        private final List<QueryableEntry<?, ?>> entries;
        private final IndexIterationPointer[] pointers;

        public MapFetchIndexOperationResult(List<QueryableEntry<?, ?>> entries, IndexIterationPointer[] pointers) {
            this.entries = entries;
            this.pointers = pointers;
        }

        public List<QueryableEntry<?, ?>> getEntries() {
            return this.entries;
        }

        public IndexIterationPointer[] getPointers() {
            return this.pointers;
        }
    }
}

