/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractGenericRecord
implements GenericRecord {
    protected abstract Object getClassIdentifier();

    public boolean equals(Object o) {
        Set<String> thisFieldNames;
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGenericRecord)) {
            return false;
        }
        AbstractGenericRecord that = (AbstractGenericRecord)o;
        if (!that.getClassIdentifier().equals(this.getClassIdentifier())) {
            return false;
        }
        Set<String> thatFieldNames = that.getFieldNames();
        if (!Objects.equals(thatFieldNames, thisFieldNames = this.getFieldNames())) {
            return false;
        }
        for (String fieldName : thatFieldNames) {
            FieldType thisFieldType;
            FieldType thatFieldType = that.getFieldType(fieldName);
            if (!thatFieldType.equals((Object)(thisFieldType = this.getFieldType(fieldName)))) {
                return false;
            }
            if (!(thatFieldType.isArrayType() ? !Objects.deepEquals(this.readAny(fieldName), that.readAny(fieldName)) : !Objects.equals(this.readAny(fieldName), that.readAny(fieldName)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.getClassIdentifier());
        Set<String> thisFieldNames = this.getFieldNames();
        for (String fieldName : thisFieldNames) {
            FieldType fieldType = this.getFieldType(fieldName);
            result = 31 * result + FieldOperations.fieldOperations(fieldType).hashCode(this, fieldName);
        }
        return result;
    }

    public final <T> T readAny(@Nonnull String fieldName) {
        FieldType type = this.getFieldType(fieldName);
        return (T)FieldOperations.fieldOperations(type).readGenericRecordOrPrimitive(this, fieldName);
    }
}

