/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nonapi.io.github.classgraph.scanspec;

import com.hazelcast.io.github.classgraph.ClassGraph;
import com.hazelcast.io.github.classgraph.ClassGraphException;
import com.hazelcast.io.github.classgraph.ModulePathInfo;
import com.hazelcast.nonapi.io.github.classgraph.scanspec.WhiteBlackList;
import com.hazelcast.nonapi.io.github.classgraph.utils.LogNode;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScanSpec {
    public WhiteBlackList.WhiteBlackListWholeString packageWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('.');
    public WhiteBlackList.WhiteBlackListPrefix packagePrefixWhiteBlackList = new WhiteBlackList.WhiteBlackListPrefix('.');
    public WhiteBlackList.WhiteBlackListWholeString pathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('/');
    public WhiteBlackList.WhiteBlackListPrefix pathPrefixWhiteBlackList = new WhiteBlackList.WhiteBlackListPrefix('/');
    public WhiteBlackList.WhiteBlackListWholeString classWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('.');
    public WhiteBlackList.WhiteBlackListWholeString classfilePathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('/');
    public WhiteBlackList.WhiteBlackListWholeString classPackageWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('.');
    public WhiteBlackList.WhiteBlackListWholeString classPackagePathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('/');
    public WhiteBlackList.WhiteBlackListWholeString moduleWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('.');
    public WhiteBlackList.WhiteBlackListLeafname jarWhiteBlackList = new WhiteBlackList.WhiteBlackListLeafname('/');
    public WhiteBlackList.WhiteBlackListWholeString classpathElementResourcePathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString('/');
    public WhiteBlackList.WhiteBlackListLeafname libOrExtJarWhiteBlackList = new WhiteBlackList.WhiteBlackListLeafname('/');
    public boolean scanJars = true;
    public boolean scanNestedJars = true;
    public boolean scanDirs = true;
    public boolean scanModules = true;
    public boolean enableClassInfo;
    public boolean enableFieldInfo;
    public boolean enableMethodInfo;
    public boolean enableAnnotationInfo;
    public boolean enableStaticFinalFieldConstantInitializerValues;
    public boolean enableInterClassDependencies;
    public boolean enableExternalClasses;
    public boolean enableSystemJarsAndModules;
    public boolean ignoreClassVisibility;
    public boolean ignoreFieldVisibility;
    public boolean ignoreMethodVisibility;
    public boolean disableRuntimeInvisibleAnnotations;
    public boolean extendScanningUpwardsToExternalClasses = true;
    public Set<String> allowedURLSchemes;
    public transient List<ClassLoader> addedClassLoaders;
    public transient List<ClassLoader> overrideClassLoaders;
    public transient List<Object> addedModuleLayers;
    public transient List<Object> overrideModuleLayers;
    public List<Object> overrideClasspath;
    public transient List<ClassGraph.ClasspathElementFilter> classpathElementFilters;
    public boolean initializeLoadedClasses;
    public boolean removeTemporaryFilesAfterScan;
    public boolean ignoreParentClassLoaders;
    public boolean ignoreParentModuleLayers;
    public ModulePathInfo modulePathInfo = new ModulePathInfo();
    public int maxBufferedJarRAMSize = 0x4000000;
    public boolean enableMemoryMapping;

    public void sortPrefixes() {
        for (Field field : ScanSpec.class.getDeclaredFields()) {
            if (!WhiteBlackList.class.isAssignableFrom(field.getType())) continue;
            try {
                ((WhiteBlackList)field.get(this)).sortPrefixes();
            }
            catch (ReflectiveOperationException e) {
                throw ClassGraphException.newClassGraphException("Field is not accessible: " + field, e);
            }
        }
    }

    public void addClasspathOverride(Object overrideClasspathElement) {
        if (this.overrideClasspath == null) {
            this.overrideClasspath = new ArrayList<Object>();
        }
        this.overrideClasspath.add(overrideClasspathElement instanceof String || overrideClasspathElement instanceof URL || overrideClasspathElement instanceof URI ? overrideClasspathElement : overrideClasspathElement.toString());
    }

    public void filterClasspathElements(ClassGraph.ClasspathElementFilter classpathElementFilter) {
        if (this.classpathElementFilters == null) {
            this.classpathElementFilters = new ArrayList<ClassGraph.ClasspathElementFilter>(2);
        }
        this.classpathElementFilters.add(classpathElementFilter);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this.addedClassLoaders == null) {
            this.addedClassLoaders = new ArrayList<ClassLoader>();
        }
        if (classLoader != null) {
            this.addedClassLoaders.add(classLoader);
        }
    }

    public void enableURLScheme(String scheme) {
        if (scheme == null || scheme.length() < 2) {
            throw new IllegalArgumentException("URL schemes must contain at least two characters");
        }
        if (this.allowedURLSchemes == null) {
            this.allowedURLSchemes = new HashSet<String>();
        }
        this.allowedURLSchemes.add(scheme.toLowerCase());
    }

    public void overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        if (overrideClassLoaders.length == 0) {
            throw new IllegalArgumentException("At least one override ClassLoader must be provided");
        }
        this.addedClassLoaders = null;
        this.overrideClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : overrideClassLoaders) {
            if (classLoader == null) continue;
            this.overrideClassLoaders.add(classLoader);
        }
    }

    private static boolean isModuleLayer(Object moduleLayer) {
        if (moduleLayer == null) {
            throw new IllegalArgumentException("ModuleLayer references must not be null");
        }
        for (Class<?> currClass = moduleLayer.getClass(); currClass != null; currClass = currClass.getSuperclass()) {
            if (!currClass.getName().equals("java.lang.ModuleLayer")) continue;
            return true;
        }
        return false;
    }

    public void addModuleLayer(Object moduleLayer) {
        if (!ScanSpec.isModuleLayer(moduleLayer)) {
            throw new IllegalArgumentException("moduleLayer must be of type java.lang.ModuleLayer");
        }
        if (this.addedModuleLayers == null) {
            this.addedModuleLayers = new ArrayList<Object>();
        }
        this.addedModuleLayers.add(moduleLayer);
    }

    public void overrideModuleLayers(Object ... overrideModuleLayers) {
        if (overrideModuleLayers == null) {
            throw new IllegalArgumentException("overrideModuleLayers cannot be null");
        }
        if (overrideModuleLayers.length == 0) {
            throw new IllegalArgumentException("At least one override ModuleLayer must be provided");
        }
        for (Object moduleLayer : overrideModuleLayers) {
            if (ScanSpec.isModuleLayer(moduleLayer)) continue;
            throw new IllegalArgumentException("moduleLayer must be of type java.lang.ModuleLayer");
        }
        this.addedModuleLayers = null;
        this.overrideModuleLayers = new ArrayList<Object>();
        Collections.addAll(this.overrideModuleLayers, overrideModuleLayers);
    }

    public ScanSpecPathMatch dirWhitelistMatchStatus(String relativePath) {
        if (this.pathWhiteBlackList.isBlacklisted(relativePath)) {
            return ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX;
        }
        if (this.pathPrefixWhiteBlackList.isBlacklisted(relativePath)) {
            return ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX;
        }
        if (this.pathWhiteBlackList.whitelistIsEmpty() && this.classPackagePathWhiteBlackList.whitelistIsEmpty()) {
            return relativePath.isEmpty() || relativePath.equals("/") ? ScanSpecPathMatch.AT_WHITELISTED_PATH : ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX;
        }
        if (this.pathWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_PATH;
        }
        if (this.classPackagePathWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        if (this.pathPrefixWhiteBlackList.isSpecificallyWhitelisted(relativePath)) {
            return ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX;
        }
        if (relativePath.equals("/")) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.pathWhiteBlackList.whitelistHasPrefix(relativePath)) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.classfilePathWhiteBlackList.whitelistHasPrefix(relativePath)) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    public boolean classfileIsSpecificallyWhitelisted(String relativePath) {
        return this.classfilePathWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(relativePath);
    }

    public boolean classOrPackageIsBlacklisted(String className) {
        return this.classWhiteBlackList.isBlacklisted(className) || this.packagePrefixWhiteBlackList.isBlacklisted(className);
    }

    public void log(LogNode log) {
        if (log != null) {
            LogNode scanSpecLog = log.log("ScanSpec:");
            for (Field field : ScanSpec.class.getDeclaredFields()) {
                try {
                    scanSpecLog.log(field.getName() + ": " + field.get(this));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }

    public static enum ScanSpecPathMatch {
        HAS_BLACKLISTED_PATH_PREFIX,
        HAS_WHITELISTED_PATH_PREFIX,
        AT_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH;

    }
}

