/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.avatica.remote;

import com.hazelcast.org.apache.calcite.avatica.remote.AuthenticationType;
import com.hazelcast.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.hazelcast.org.apache.calcite.avatica.remote.HostnameVerificationConfigurable;
import com.hazelcast.org.apache.calcite.avatica.remote.KeyStoreConfigurable;
import com.hazelcast.org.apache.calcite.avatica.remote.TrustStoreConfigurable;
import com.hazelcast.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import com.hazelcast.org.slf4j.Logger;
import com.hazelcast.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient,
UsernamePasswordAuthenticateable,
TrustStoreConfigurable,
KeyStoreConfigurable,
HostnameVerificationConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_KEY = "avatica.pooled.connections.per.route";
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT = "25";
    private static final String MAX_POOLED_CONNECTIONS_KEY = "avatica.pooled.connections.max";
    private static final String MAX_POOLED_CONNECTIONS_DEFAULT = "100";
    protected final HttpHost host;
    protected final URI uri;
    protected BasicAuthCache authCache;
    protected CloseableHttpClient client;
    protected Registry<ConnectionSocketFactory> socketFactoryRegistry;
    protected PoolingHttpClientConnectionManager pool;
    protected UsernamePasswordCredentials credentials = null;
    protected CredentialsProvider credentialsProvider = null;
    protected Lookup<AuthSchemeProvider> authRegistry = null;
    protected Object userToken;
    protected File truststore = null;
    protected File keystore = null;
    protected String truststorePassword = null;
    protected String keystorePassword = null;
    protected String keyPassword = null;
    protected HostnameVerificationConfigurable.HostnameVerification hostnameVerification = null;

    public AvaticaCommonsHttpClientImpl(URL url) {
        this.host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        this.uri = AvaticaCommonsHttpClientImpl.toURI(Objects.requireNonNull(url));
        this.initializeClient();
    }

    protected void initializeClient() {
        this.socketFactoryRegistry = this.configureSocketFactories();
        this.configureConnectionPool(this.socketFactoryRegistry);
        this.authCache = new BasicAuthCache();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.pool).build();
    }

    protected void configureConnectionPool(Registry<ConnectionSocketFactory> registry) {
        this.pool = new PoolingHttpClientConnectionManager(registry);
        String maxCnxns = System.getProperty(MAX_POOLED_CONNECTIONS_KEY, MAX_POOLED_CONNECTIONS_DEFAULT);
        this.pool.setMaxTotal(Integer.parseInt(maxCnxns));
        String maxCnxnsPerRoute = System.getProperty(MAX_POOLED_CONNECTION_PER_ROUTE_KEY, MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT);
        this.pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
    }

    protected Registry<ConnectionSocketFactory> configureSocketFactories() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (this.host.getSchemeName().equalsIgnoreCase("https")) {
            this.configureHttpsRegistry((RegistryBuilder<ConnectionSocketFactory>)registryBuilder);
        } else {
            this.configureHttpRegistry((RegistryBuilder<ConnectionSocketFactory>)registryBuilder);
        }
        return registryBuilder.build();
    }

    protected void configureHttpsRegistry(RegistryBuilder<ConnectionSocketFactory> registryBuilder) {
        try {
            SSLContext sslContext = this.getSSLContext();
            HostnameVerifier verifier = this.getHostnameVerifier(this.hostnameVerification);
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, verifier);
            registryBuilder.register("https", (Object)sslFactory);
        }
        catch (Exception e) {
            LOG.error("HTTPS registry configuration failed");
            throw new RuntimeException(e);
        }
    }

    private SSLContext getSSLContext() throws Exception {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (null != this.truststore && null != this.truststorePassword) {
            this.loadTrustStore(sslContextBuilder);
        }
        if (null != this.keystore && null != this.keystorePassword && null != this.keyPassword) {
            this.loadKeyStore(sslContextBuilder);
        }
        return sslContextBuilder.build();
    }

    protected void loadKeyStore(SSLContextBuilder sslContextBuilder) throws Exception {
        sslContextBuilder.loadKeyMaterial(this.keystore, this.keystorePassword.toCharArray(), this.keyPassword.toCharArray());
    }

    protected void loadTrustStore(SSLContextBuilder sslContextBuilder) throws Exception {
        sslContextBuilder.loadTrustMaterial(this.truststore, this.truststorePassword.toCharArray());
    }

    protected void configureHttpRegistry(RegistryBuilder<ConnectionSocketFactory> registryBuilder) {
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
    }

    HostnameVerifier getHostnameVerifier(HostnameVerificationConfigurable.HostnameVerification verification) {
        if (verification == null) {
            verification = HostnameVerificationConfigurable.HostnameVerification.STRICT;
        }
        switch (verification) {
            case STRICT: {
                return SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            }
            case NONE: {
                return NoopHostnameVerifier.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unhandled HostnameVerification: " + (Object)((Object)this.hostnameVerification));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        while (true) {
            HttpClientContext context = HttpClientContext.create();
            context.setTargetHost(this.host);
            if (null != this.credentials) {
                context.setCredentialsProvider(this.credentialsProvider);
                context.setAuthSchemeRegistry(this.authRegistry);
                context.setAuthCache((AuthCache)this.authCache);
            }
            if (null != this.userToken) {
                context.setUserToken(this.userToken);
            }
            ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
            HttpPost post = new HttpPost(this.uri);
            post.setEntity((HttpEntity)entity);
            try {
                CloseableHttpResponse response = this.execute(post, context);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (200 == statusCode || 500 == statusCode) {
                        this.userToken = context.getUserToken();
                        byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                        return byArray;
                    }
                    if (503 == statusCode) {
                        LOG.debug("Failed to connect to server (HTTP/503), retrying");
                        continue;
                    }
                    throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                    continue;
                }
            }
            catch (NoHttpResponseException e) {
                LOG.debug("The server failed to issue an HTTP response, retrying");
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    CloseableHttpResponse execute(HttpPost post, HttpClientContext context) throws IOException, ClientProtocolException {
        return this.client.execute((HttpUriRequest)post, (HttpContext)context);
    }

    @Override
    public void setUsernamePassword(AuthenticationType authType, String username, String password) {
        this.credentials = new UsernamePasswordCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password));
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)this.credentials);
        RegistryBuilder authRegistryBuilder = RegistryBuilder.create();
        switch (authType) {
            case BASIC: {
                authRegistryBuilder.register("Basic", (Object)new BasicSchemeFactory());
                break;
            }
            case DIGEST: {
                authRegistryBuilder.register("Digest", (Object)new DigestSchemeFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentiation type: " + (Object)((Object)authType));
            }
        }
        this.authRegistry = authRegistryBuilder.build();
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTrustStore(File truststore, String password) {
        this.truststore = Objects.requireNonNull(truststore);
        if (!truststore.exists() || !truststore.isFile()) {
            throw new IllegalArgumentException("Truststore is must be an existing, regular file: " + truststore);
        }
        this.truststorePassword = Objects.requireNonNull(password);
        this.initializeClient();
    }

    @Override
    public void setKeyStore(File keystore, String keystorepassword, String keypassword) {
        this.keystore = Objects.requireNonNull(keystore);
        if (!keystore.exists() || !keystore.isFile()) {
            throw new IllegalArgumentException("Keystore is must be an existing, regular file: " + keystore);
        }
        this.keystorePassword = Objects.requireNonNull(keystorepassword);
        this.keyPassword = Objects.requireNonNull(keypassword);
        this.initializeClient();
    }

    @Override
    public void setHostnameVerification(HostnameVerificationConfigurable.HostnameVerification verification) {
        this.hostnameVerification = Objects.requireNonNull(verification);
        this.initializeClient();
    }
}

