/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.codehaus.janino;

import com.hazelcast.org.codehaus.commons.compiler.CompileException;
import com.hazelcast.org.codehaus.commons.nullanalysis.Nullable;
import com.hazelcast.org.codehaus.janino.Compiler;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Path;

public class AntCompilerAdapter
extends DefaultCompilerAdapter {
    public boolean execute() {
        boolean debugVars;
        boolean debugLines;
        boolean debugSource;
        File[] sourceFiles = this.compileList;
        File destinationDirectory = this.destDir == null ? Compiler.NO_DESTINATION_DIRECTORY : this.destDir;
        File[] optionalSourcePath = AntCompilerAdapter.pathToFiles(this.compileSourcepath != null ? this.compileSourcepath : this.src);
        File[] classPath = AntCompilerAdapter.pathToFiles(this.compileClasspath, new File[]{new File(".")});
        File[] optionalExtDirs = AntCompilerAdapter.pathToFiles(this.extdirs);
        File[] optionalBootClassPath = AntCompilerAdapter.pathToFiles(this.bootclasspath);
        String optionalCharacterEncoding = this.encoding;
        boolean verbose = this.verbose;
        if (!this.debug) {
            debugSource = false;
            debugLines = false;
            debugVars = false;
        } else {
            String debugLevel = this.attributes.getDebugLevel();
            if (debugLevel == null) {
                debugSource = true;
                debugLines = true;
                debugVars = false;
            } else {
                debugSource = false;
                debugLines = false;
                debugVars = false;
                if (debugLevel.indexOf("source") != -1) {
                    debugSource = true;
                }
                if (debugLevel.indexOf("lines") != -1) {
                    debugLines = true;
                }
                if (debugLevel.indexOf("vars") != -1) {
                    debugVars = true;
                }
            }
        }
        try {
            new Compiler(optionalSourcePath, classPath, optionalExtDirs, optionalBootClassPath, destinationDirectory, optionalCharacterEncoding, verbose, debugSource, debugLines, debugVars, Compiler.DEFAULT_WARNING_HANDLE_PATTERNS, false).compile(sourceFiles);
        }
        catch (CompileException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    @Nullable
    private static File[] pathToFiles(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        String[] fileNames = path.list();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    private static File[] pathToFiles(@Nullable Path path, File[] defaultValue) {
        if (path == null) {
            return defaultValue;
        }
        File[] result = AntCompilerAdapter.pathToFiles(path);
        assert (result != null);
        return result;
    }
}

