/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema;

import com.hazelcast.org.everit.json.schema.CollectingFailureReporter;
import com.hazelcast.org.everit.json.schema.EarlyFailingFailureReporter;
import com.hazelcast.org.everit.json.schema.InternalValidationException;
import com.hazelcast.org.everit.json.schema.ReadWriteContext;
import com.hazelcast.org.everit.json.schema.ReadWriteValidator;
import com.hazelcast.org.everit.json.schema.Schema;
import com.hazelcast.org.everit.json.schema.ValidatingVisitor;
import com.hazelcast.org.everit.json.schema.ValidationFailureReporter;
import com.hazelcast.org.everit.json.schema.Validator;
import com.hazelcast.org.everit.json.schema.event.ValidationListener;

class DefaultValidator
implements Validator {
    private boolean failEarly;
    private final ReadWriteContext readWriteContext;
    private final ValidationListener validationListener;

    DefaultValidator(boolean failEarly, ReadWriteContext readWriteContext, ValidationListener validationListener) {
        this.failEarly = failEarly;
        this.readWriteContext = readWriteContext;
        this.validationListener = validationListener;
    }

    @Override
    public void performValidation(Schema schema, Object input) {
        ValidationFailureReporter failureReporter = this.createFailureReporter(schema);
        ReadWriteValidator readWriteValidator = ReadWriteValidator.createForContext(this.readWriteContext, failureReporter);
        ValidatingVisitor visitor = new ValidatingVisitor(input, failureReporter, readWriteValidator, this.validationListener);
        try {
            visitor.visit(schema);
            visitor.failIfErrorFound();
        }
        catch (InternalValidationException e) {
            throw e.copy();
        }
    }

    private ValidationFailureReporter createFailureReporter(Schema schema) {
        if (this.failEarly) {
            return new EarlyFailingFailureReporter(schema);
        }
        return new CollectingFailureReporter(schema);
    }
}

