/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.HazelcastClientBeanDefinitionParser;
import com.hazelcast.spring.config.ConfigFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HazelcastFailoverClientBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        return springXmlBuilder.handleMultipleClusterAwareClient(element);
    }

    class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;
        private final BeanDefinitionBuilder failoverConfigBuilder;

        SpringXmlBuilder(ParserContext parserContext) {
            this(parserContext, BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class).setFactoryMethod("newHazelcastFailoverClient").setDestroyMethodName("shutdown"));
        }

        SpringXmlBuilder(ParserContext parserContext, BeanDefinitionBuilder builder) {
            this.parserContext = parserContext;
            this.builder = builder;
            this.failoverConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConfigFactory.class, (String)"newClientFailoverConfig");
        }

        AbstractBeanDefinition handleMultipleClusterAwareClient(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            String attribute = element.getAttribute("try-count");
            this.failoverConfigBuilder.addPropertyValue("tryCount", (Object)Integer.valueOf(attribute));
            ManagedList configs = new ManagedList();
            for (Node node : DomConfigHelper.childElements(element)) {
                HazelcastClientBeanDefinitionParser.SpringXmlBuilder springXmlBuilder = new HazelcastClientBeanDefinitionParser.SpringXmlBuilder(this.parserContext);
                configs.add((Object)springXmlBuilder.createConfigBean(node));
            }
            this.failoverConfigBuilder.addPropertyValue("clientConfigs", (Object)configs);
            this.builder.addConstructorArgValue((Object)this.failoverConfigBuilder.getBeanDefinition());
            return this.builder.getBeanDefinition();
        }
    }
}

