/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.calcite.opt.AbstractMapScanRel;
import com.hazelcast.sql.impl.calcite.opt.cost.CostUtils;
import com.hazelcast.sql.impl.calcite.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.PhysicalRelVisitor;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.List;

public class MapIndexScanPhysicalRel
extends AbstractMapScanRel
implements PhysicalRel {
    private final MapTableIndex index;
    private final IndexFilter indexFilter;
    private final List<QueryDataType> converterTypes;
    private final RexNode indexExp;
    private final RexNode remainderExp;

    public MapIndexScanPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, MapTableIndex index, IndexFilter indexFilter, List<QueryDataType> converterTypes, RexNode indexExp, RexNode remainderExp) {
        super(cluster, traitSet, table);
        this.index = index;
        this.indexFilter = indexFilter;
        this.converterTypes = converterTypes;
        this.indexExp = indexExp;
        this.remainderExp = remainderExp;
    }

    public MapTableIndex getIndex() {
        return this.index;
    }

    public IndexFilter getIndexFilter() {
        return this.indexFilter;
    }

    public List<QueryDataType> getConverterTypes() {
        return this.converterTypes;
    }

    public RexNode getRemainderExp() {
        return this.remainderExp;
    }

    public List<Boolean> getAscs() {
        RelCollation collation = this.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
        assert (collation != null);
        int size = collation.getFieldCollations().size();
        ArrayList<Boolean> ascs = new ArrayList<Boolean>(size);
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            Boolean asc = fieldCollation.getDirection() == RelFieldCollation.Direction.ASCENDING ? Boolean.TRUE : Boolean.FALSE;
            ascs.add(asc);
        }
        return ascs;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MapIndexScanPhysicalRel(this.getCluster(), traitSet, this.getTable(), this.index, this.indexFilter, this.converterTypes, this.indexExp, this.remainderExp);
    }

    @Override
    public void visit(PhysicalRelVisitor visitor) {
        visitor.onMapIndexScan(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("index", this.index.getName()).item("indexExp", this.indexExp).item("remainderExp", this.remainderExp);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double rowCount = this.table.getRowCount();
        if (this.indexExp != null) {
            rowCount = CostUtils.adjustFilteredRowCount(rowCount, RelMdUtil.guessSelectivity(this.indexExp));
        }
        if (this.remainderExp != null) {
            rowCount = CostUtils.adjustFilteredRowCount(rowCount, RelMdUtil.guessSelectivity(this.remainderExp));
        }
        return rowCount;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double scanRowCount = this.table.getRowCount();
        if (this.indexExp != null) {
            scanRowCount = CostUtils.adjustFilteredRowCount(scanRowCount, RelMdUtil.guessSelectivity(this.indexExp));
        }
        boolean hasFilter = this.remainderExp != null;
        double filterRowCount = scanRowCount;
        if (hasFilter) {
            filterRowCount = CostUtils.adjustFilteredRowCount(filterRowCount, RelMdUtil.guessSelectivity(this.remainderExp));
        }
        return this.computeSelfCost(planner, scanRowCount, CostUtils.indexScanCpuMultiplier(this.index.getType()), hasFilter, filterRowCount, this.getTableUnwrapped().getProjects().size());
    }
}

