/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.parse;

import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParser;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserImplFactory;
import com.hazelcast.org.apache.calcite.sql.parser.impl.ParseException;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.CalciteConfiguration;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlConformance;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import java.util.List;
import javax.annotation.Nonnull;

public class QueryParser {
    private final HazelcastTypeFactory typeFactory;
    private final Prepare.CatalogReader catalogReader;
    private final SqlConformance conformance;
    private final List<Object> arguments;
    private final SqlBackend sqlBackend;
    private final SqlBackend jetSqlBackend;

    public QueryParser(HazelcastTypeFactory typeFactory, Prepare.CatalogReader catalogReader, SqlConformance conformance, List<Object> arguments, @Nonnull SqlBackend sqlBackend, @Nonnull SqlBackend jetSqlBackend) {
        this.typeFactory = typeFactory;
        this.catalogReader = catalogReader;
        this.conformance = conformance;
        this.arguments = arguments;
        this.sqlBackend = sqlBackend;
        this.jetSqlBackend = jetSqlBackend;
    }

    public QueryParseResult parse(String sql) {
        try {
            return this.parse(sql, this.sqlBackend);
        }
        catch (Exception e) {
            try {
                return this.parse(sql, this.jetSqlBackend);
            }
            catch (Exception e2) {
                String message = e2 instanceof SqlParseException && e2.getCause() instanceof ParseException ? QueryParser.trimMessage(e2.getMessage()) : e2.getMessage();
                throw QueryException.error(1008, message, e2);
            }
        }
    }

    private QueryParseResult parse(String sql, SqlBackend sqlBackend) throws SqlParseException {
        SqlParser.Config config = QueryParser.createConfig(sqlBackend.parserFactory());
        SqlParser parser = SqlParser.create(sql, config);
        SqlNodeList statements = parser.parseStmtList();
        if (statements.size() != 1) {
            throw QueryException.error(1008, "The command must contain a single statement");
        }
        SqlNode topNode = statements.get(0);
        HazelcastSqlValidator validator = (HazelcastSqlValidator)sqlBackend.validator(this.catalogReader, this.typeFactory, this.conformance, this.arguments);
        SqlNode node = validator.validate(topNode);
        SqlVisitor<Void> visitor = sqlBackend.unsupportedOperationVisitor(this.catalogReader);
        node.accept(visitor);
        return new QueryParseResult(node, new QueryParameterMetadata(validator.getParameterConverters(node)), validator, sqlBackend, validator.isInfiniteRows());
    }

    private static SqlParser.Config createConfig(SqlParserImplFactory parserImplFactory) {
        SqlParser.ConfigBuilder configBuilder = SqlParser.configBuilder();
        CalciteConfiguration.DEFAULT.toParserConfig(configBuilder);
        configBuilder.setConformance(HazelcastSqlConformance.INSTANCE);
        if (parserImplFactory != null) {
            configBuilder.setParserFactory(parserImplFactory);
        }
        return configBuilder.build();
    }

    private static String trimMessage(String message) {
        String eol = System.getProperty("line.separator", "\n");
        String[] parts = message.split(eol, 2);
        return parts[0];
    }
}

