/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.parse;

import com.hazelcast.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.SqlBasicTypeNameSpec;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import java.util.HashSet;
import java.util.Set;

public final class UnsupportedOperationVisitor
implements SqlVisitor<Void> {
    private static final Resource RESOURCE = Resources.create(Resource.class);
    private static final Set<SqlKind> SUPPORTED_KINDS = new HashSet<SqlKind>();
    private static final Set<SqlOperator> SUPPORTED_OPERATORS;
    private final SqlValidatorCatalogReader catalogReader;
    private SqlSelect topLevelSelect;

    public UnsupportedOperationVisitor(SqlValidatorCatalogReader catalogReader) {
        this.catalogReader = catalogReader;
    }

    @Override
    public Void visit(SqlCall call) {
        this.processCall(call);
        call.getOperator().acceptCall(this, call);
        return null;
    }

    @Override
    public Void visit(SqlNodeList nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            SqlNode node = nodeList.get(i);
            node.accept(this);
        }
        return null;
    }

    @Override
    public Void visit(SqlIdentifier id) {
        Object target;
        HazelcastTable hzTable;
        SqlValidatorTable table = this.catalogReader.getTable(id.names);
        if (table != null && (hzTable = table.unwrap(HazelcastTable.class)) != null && (target = hzTable.getTarget()) != null && !(target instanceof AbstractMapTable)) {
            throw UnsupportedOperationVisitor.error((SqlNode)id, RESOURCE.custom(target.getClass().getSimpleName() + " is not supported"));
        }
        return null;
    }

    @Override
    public Void visit(SqlDataTypeSpec type) {
        Object typeName;
        if (type.getTypeNameSpec() instanceof SqlUserDefinedTypeNameSpec && HazelcastTypeUtils.isObjectIdentifier((SqlIdentifier)(typeName = type.getTypeName()))) {
            return null;
        }
        if (!(type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec)) {
            throw UnsupportedOperationVisitor.error((SqlNode)type, RESOURCE.custom("Complex type specifications are not supported"));
        }
        typeName = SqlTypeName.get(type.getTypeName().getSimple());
        switch (1.$SwitchMap$org$apache$calcite$sql$type$SqlTypeName[((Enum)typeName).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return null;
            }
        }
        throw UnsupportedOperationVisitor.error((SqlNode)type, RESOURCE.notSupported(((SqlTypeName)((Object)typeName)).getName()));
    }

    @Override
    public Void visit(SqlDynamicParam param) {
        return null;
    }

    @Override
    public Void visit(SqlLiteral literal) {
        SqlTypeName typeName = literal.getTypeName();
        if (HazelcastTypeUtils.isIntervalType(typeName)) {
            return null;
        }
        switch (typeName) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: 
            case VARCHAR: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case NULL: 
            case CHAR: 
            case ANY: {
                return null;
            }
            case SYMBOL: {
                Object symbolValue = literal.getValue();
                if (symbolValue instanceof SqlTrimFunction.Flag) {
                    return null;
                }
                throw UnsupportedOperationVisitor.error((SqlNode)literal, RESOURCE.custom(symbolValue + " literal is not supported"));
            }
        }
        throw UnsupportedOperationVisitor.error((SqlNode)literal, RESOURCE.custom((Object)((Object)typeName) + " literals are not supported"));
    }

    @Override
    public Void visit(SqlIntervalQualifier intervalQualifier) {
        return null;
    }

    private void processCall(SqlCall call) {
        SqlKind kind = call.getKind();
        if (SUPPORTED_KINDS.contains((Object)kind)) {
            return;
        }
        switch (kind) {
            case SELECT: {
                this.processSelect((SqlSelect)call);
                return;
            }
            case DESCENDING: 
            case POSITION: 
            case EXTRACT: 
            case OTHER: 
            case OTHER_FUNCTION: {
                this.processOther(call);
                break;
            }
            default: {
                throw this.unsupported(call);
            }
        }
    }

    private void processSelect(SqlSelect select) {
        if (select.getGroup() != null && select.getGroup().size() > 0) {
            throw UnsupportedOperationVisitor.unsupported(select.getGroup(), "GROUP BY");
        }
        if (this.topLevelSelect == null) {
            this.topLevelSelect = select;
        } else if (select.getFetch() != null || select.getOffset() != null) {
            throw UnsupportedOperationVisitor.error((SqlNode)select, "FETCH/OFFSET is only supported for the top-level SELECT");
        }
    }

    private void processOther(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (SUPPORTED_OPERATORS.contains(operator)) {
            return;
        }
        throw UnsupportedOperationVisitor.unsupported(call, operator.getName());
    }

    private CalciteContextException unsupported(SqlCall call) {
        String name = call.getOperator().getName();
        return UnsupportedOperationVisitor.unsupported(call, name.replace("$", "").replace('_', ' '));
    }

    private static CalciteContextException unsupported(SqlNode node, String name) {
        return UnsupportedOperationVisitor.error(node, RESOURCE.notSupported(name));
    }

    private static CalciteContextException error(SqlNode node, Resources.ExInst<SqlValidatorException> err) {
        return SqlUtil.newContextException(node.getParserPosition(), err);
    }

    public static CalciteContextException error(SqlNode node, String name) {
        return UnsupportedOperationVisitor.error(node, RESOURCE.custom(name));
    }

    static {
        SUPPORTED_KINDS.add(SqlKind.AND);
        SUPPORTED_KINDS.add(SqlKind.OR);
        SUPPORTED_KINDS.add(SqlKind.NOT);
        SUPPORTED_KINDS.add(SqlKind.IN);
        SUPPORTED_KINDS.add(SqlKind.NOT_IN);
        SUPPORTED_KINDS.add(SqlKind.BETWEEN);
        SUPPORTED_KINDS.add(SqlKind.PLUS);
        SUPPORTED_KINDS.add(SqlKind.MINUS);
        SUPPORTED_KINDS.add(SqlKind.TIMES);
        SUPPORTED_KINDS.add(SqlKind.DIVIDE);
        SUPPORTED_KINDS.add(SqlKind.MOD);
        SUPPORTED_KINDS.add(SqlKind.MINUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.PLUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.IS_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NULL);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_NULL);
        SUPPORTED_KINDS.add(SqlKind.EQUALS);
        SUPPORTED_KINDS.add(SqlKind.NOT_EQUALS);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.AS);
        SUPPORTED_KINDS.add(SqlKind.CAST);
        SUPPORTED_KINDS.add(SqlKind.CEIL);
        SUPPORTED_KINDS.add(SqlKind.FLOOR);
        SUPPORTED_KINDS.add(SqlKind.LIKE);
        SUPPORTED_KINDS.add(SqlKind.TRIM);
        SUPPORTED_KINDS.add(SqlKind.CASE);
        SUPPORTED_KINDS.add(SqlKind.NULLIF);
        SUPPORTED_KINDS.add(SqlKind.COALESCE);
        SUPPORTED_OPERATORS = new HashSet<SqlOperator>();
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.POWER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SQUARE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SQRT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CBRT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.COS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SIN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TAN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.COT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ACOS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ASIN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ATAN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ATAN2);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.EXP);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LOG10);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.RAND);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ABS);
        SUPPORTED_OPERATORS.add(SqlStdOperatorTable.PI);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SIGN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.DEGREES);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.RADIANS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ROUND);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TRUNCATE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ASCII);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.INITCAP);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CHAR_LENGTH);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CHARACTER_LENGTH);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LENGTH);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LOWER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.UPPER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CONCAT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SUBSTRING);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LTRIM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.RTRIM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.BTRIM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.REPLACE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.POSITION);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.EXTRACT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TO_TIMESTAMP_TZ);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TO_EPOCH_MILLIS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.DESC);
    }

    public static interface Resource {
        @Resources.BaseMessage(value="{0}")
        public Resources.ExInst<SqlValidatorException> custom(String var1);

        @Resources.BaseMessage(value="{0} is not supported")
        public Resources.ExInst<SqlValidatorException> notSupported(String var1);
    }
}

